package org.lsst.ccs.config;

/**
 * A class that matches the value of a configuration parameter with the
 * SingleCategoryTag from which it originated.
 * 
 * @author The LSST CCS Team
 */
public class ConfigurationParameterTaggedValue {
    
    private final String parameterPath;
    private final String parameterValue;
    private final SingleCategoryTag singleCategoryTag;
    
    public ConfigurationParameterTaggedValue(String parameterPath, String parameterValue, SingleCategoryTag singleCategoryTag) {
        this.parameterPath = parameterPath;
        this.parameterValue = parameterValue;
        this.singleCategoryTag = singleCategoryTag;
    }

    public String getParameterPath() {
        return parameterPath;
    }

    public String getParameterValue() {
        return parameterValue;
    }

    public SingleCategoryTag getSingleCategoryTag() {
        return singleCategoryTag;
    }

    @Override
    public String toString() {
        return parameterPath+": "+parameterValue+" ("+singleCategoryTag+")";
    }
    
    
}
