package org.lsst.ccs.config;

/**
 * A configuration parameter description class.
 * This class is used to overwrite arguments as specified in the ConfigurationParameter annotation.
 * 
 * The following is an example of how to create a custom ConfigurationParameterDescription:
 * 
 * ConfigurationParameterDescription cpd = new ConfigurationParameterDescription().withName("somePar").withCategory("myCategory");
 * 
 * @author The LSST CCS Team
 */
public class ConfigurationParameterDescription {
    
    private String name = null;
    private String description = null;
    private String category = null;
    private String units = null;
    private boolean isEnabled = true;

    public ConfigurationParameterDescription withName(String name) {
        this.name = name;
        return this;
    }
  
    public ConfigurationParameterDescription withDescription(String description) {
        this.description = description;
        return this;
    }
    
    public ConfigurationParameterDescription withCategory(String category) {
        this.category = category;
        return this;
    }

    public ConfigurationParameterDescription withUnits(String units) {
        this.units = units;
        return this;
    }

    public ConfigurationParameterDescription withIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public String getName() {
        return name;
    }
    
    public String getDescription() {
        return description;
    }
    
    public String getCategory() {
        return category;
    }
    
    public String getUnits() {
        return units;
    }
    
    public boolean isEnabled() {
        return isEnabled;
    }
    
}
