/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.config.AnnotatedClass;
import org.lsst.ccs.config.ConfigurationHandlerSet;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;

public class ConfigurationHandlerBuilderTest
extends CcsTestCaseTemplate {
    private ConfigurationHandlerSet chs;
    private AnnotatedClass obj;
    private final String tagName = "tag";

    @Test
    public void testCallToSetter() throws Exception {
        this.obj = new AnnotatedClass();
        this.chs = new ConfigurationHandlerSet();
        this.chs.addConfigurationHandlerForObject("main", (Object)this.obj);
        this.chs.initialize("tag", "someAlias");
        this.chs.setSingleParameter("main", "parm1", (Object)"hi");
        Assert.assertTrue((String)"setter should be invoked", (boolean)this.obj.setterParm1Called);
    }

    @Test
    public void testDuplicateNameFail() {
        this.chs = new ConfigurationHandlerSet();
        try {
            this.chs.addConfigurationHandlerForObject("main", (Object)new IncorrectlyAnnotated());
            Assert.fail((String)"An exception should have been thrown");
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)ex.getMessage().contains("IncorrectlyAnnotated"));
        }
    }

    @Test
    public void testIllegalCategory() {
        this.chs = new ConfigurationHandlerSet();
        try {
            this.chs.addConfigurationHandlerForObject("main", (Object)new IllegalEmptyCategory());
            Assert.fail((String)"An exception should have been thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.chs.addConfigurationHandlerForObject("a", (Object)new CategoryWithIllegaCharacter());
            Assert.fail((String)"An exception should have been thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class CategoryWithIllegaCharacter {
        @ConfigurationParameter(category="Cat_A")
        private volatile int a;
    }

    public static class IllegalEmptyCategory {
        @ConfigurationParameter(category="")
        private volatile int a;
    }

    public static class IncorrectlyAnnotated {
        @ConfigurationParameter
        private volatile String someParm;
        @ConfigurationParameter(name="someParm")
        private volatile int otherParm;
    }
}

