package org.lsst.ccs.config;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/**
 * A class containing the loaded configuration data.
 * It contains CategoryDataChain classes that order the data as it was loaded
 * and it assign each value the SingleCategoryTag from which it originated.
 * 
 * @author The LSST CCS Team
 */
public class ConfigurationLoadedData {
    
    public final Map<String,CategoryDataChain> categoryDataChainMap = new ConcurrentHashMap<>();
    
    public void putCategoryDataChain(CategoryDataChain categoryDataChain) {
        String category = categoryDataChain.getCategory();
        synchronized(categoryDataChainMap) {
//            if (categoryDataChainMap.containsKey(category)) {
//                categoryDataChainMap.get(category).addCategoryDataChain(categoryDataChain);
//            } else {
                categoryDataChainMap.put(category, categoryDataChain);
//            }
        }
    }
    
    public void putConfigurationLoadedData(ConfigurationLoadedData loadedData) {
        categoryDataChainMap.putAll(loadedData.categoryDataChainMap);
    }
    
    public ConfigurationDescription getConfigurationDescription() {
        synchronized(categoryDataChainMap) {
        ConfigurationDescription confDescription = new ConfigurationDescription(categoryDataChainMap.keySet());
            for (CategoryDataChain catDataChain : categoryDataChainMap.values()) {
                for ( SingleCategoryTag tag: catDataChain.getSingleCategoryTagList() ) {
                    confDescription.putSingleTagForCategory(catDataChain.getCategory(), tag, tag.getResolvedVersion());
                }
            }
        return confDescription;
        }
    }
    
    public final Set<String> getCategories() {
        return categoryDataChainMap.keySet();
    }
    
    public CategoryDataChain getLoadedDataForCategory(String category) {
        return categoryDataChainMap.get(category);
    }
    
    public ConfigurationView getConfigurationView(Map<String,ConfigurationParameterDataChainProcessor> chainProcessorsMap) {
        ConfigurationView view = new ConfigurationView(getConfigurationDescription());

        for ( CategoryDataChain catDataChain : categoryDataChainMap.values() ) {
            Map<String, ConfigurationParameterTaggedValue> data = catDataChain.getConfigurationParameterTaggedValues();
            for ( ConfigurationParameterTaggedValue taggedValue : data.values() ) {
                String parameterPath = taggedValue.getParameterPath();
                ConfigurationParameterDataChainProcessor dataChainProcessor = chainProcessorsMap.get(parameterPath);
                if ( dataChainProcessor == null ) {
                    view.putParameterValue(taggedValue.getParameterPath(), taggedValue.getParameterValue());
                } else {
                    String parameterCategory = dataChainProcessor.getParameterCategory();
                    List<String> dataChain = categoryDataChainMap.get(parameterCategory).getConfigurationParameterValueList(parameterPath);
                    String parameterValue = dataChainProcessor.processDataChain(dataChain);
                    view.putParameterValue(parameterPath,parameterValue);                    
                }
            }
        }
        
        return view;
    }
    
}
