/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.config.ConfigurationHandlerSet;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.utilities.conv.InputConversionEngine;

public class CollectionDeltasTest
extends CcsTestCaseTemplate {
    private static ConfigurationHandlerSet.CollectionDataChainProcessor mapProcessor = new ConfigurationHandlerSet.CollectionDataChainProcessor("some/map", "cat", HashMap.class);
    private static ConfigurationHandlerSet.CollectionDataChainProcessor listProcessor = new ConfigurationHandlerSet.CollectionDataChainProcessor("some/list", "cat", ArrayList.class);

    @Test
    public void testAddingRemovingToMap() throws Exception {
        ArrayList<String> mapList = new ArrayList<String>();
        mapList.add("[k1:v1,k2:v2]");
        mapList.add("+[k3:v3,k4:v4]");
        mapList.add("+[k3:v3]-[k5:v5]");
        mapList.add("+[k3:v33,k7:v7]-[k4:]");
        Map result = (Map)InputConversionEngine.convertArgToType((String)mapProcessor.processDataChain(mapList), Map.class);
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertTrue((boolean)result.containsKey("k1"));
        Assert.assertTrue((boolean)result.containsKey("k2"));
        Assert.assertTrue((boolean)result.containsKey("k3"));
        Assert.assertTrue((boolean)result.containsKey("k7"));
        Assert.assertEquals((Object)"v33", result.get("k3"));
    }

    @Test
    public void testAddingRemovingToList() throws Exception {
        ArrayList<String> mapList = new ArrayList<String>();
        mapList.add("[e1,e2]");
        mapList.add("+[e3,e4]");
        mapList.add("+[e3]-[e5]");
        mapList.add("+[e3,e7]-[e4]");
        List result = (List)InputConversionEngine.convertArgToType((String)listProcessor.processDataChain(mapList), List.class);
        Assert.assertEquals((long)6L, (long)result.size());
        Assert.assertTrue((boolean)result.contains("e1"));
        Assert.assertTrue((boolean)result.contains("e2"));
        Assert.assertTrue((boolean)result.contains("e3"));
        Assert.assertTrue((boolean)result.contains("e7"));
    }

    @Test
    public void testInvalidFirstElementMap() throws Exception {
        ArrayList<String> mapList = new ArrayList<String>();
        mapList.add("+[k3:v3,k4:v4]");
        try {
            Map result = (Map)InputConversionEngine.convertArgToType((String)mapProcessor.processDataChain(mapList), Map.class);
            Assert.assertFalse((boolean)true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidFirstElementList() throws Exception {
        ArrayList<String> mapList = new ArrayList<String>();
        mapList.add("+[e]");
        try {
            List result = (List)InputConversionEngine.convertArgToType((String)listProcessor.processDataChain(mapList), List.class);
            Assert.assertFalse((boolean)true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

