package org.lsst.ccs.config;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/**
 * Handles a category of parameters.
 * @author LSST CCS Team
 */
public class CategoryHandler {
    
    private final String category;
    private final Set<ConfigurationParameterHandler> parameters = new TreeSet<>();
    private final Map<String,ConfigurationParameterHandler> parametersMap = new HashMap<>();
    
    CategoryHandler(String category) {
        this.category = category;
    }
    
    void addParameterHandler(ConfigurationParameterHandler cph) {
        parameters.add(cph);
        parametersMap.put(cph.getParameterPath().toString(), cph);
    }
    
    public String getCategory() {
        return category;
    } 
    
    public Collection<ConfigurationParameterHandler> getParameters() {
        return Collections.unmodifiableSet(parameters);
    }
    
    public ConfigurationParameterHandler getConfigurationParameterHandler(String path) {
        return parametersMap.get(path);
    }
}
