package org.lsst.ccs.config;

/**
 * Interface to be implemented by classes that wish to overwrite the configuration
 * parameter description as specified by the ConfigurationParameter annotation.
 * This interface gives individual instances a chance to customize the static
 * configuration description.
 * 
 * @author The LSST CCS Team
 */
public interface HasConfigurationParameterDescription {
    
    /**
     * Get a custom ConfigurationParameterDescription for the specified
     * parameter name.
     * 
     * @param parName The name of the field annotated with the ConfigurationParameter
     *                annotation.
     * 
     * @return        A ConfigurationParameterDescription for the provided field
     *                name. If not null it will be used to overwrite the parameter
     *                description as specified in the ConfigurationParameter annotation.
     */
    public default ConfigurationParameterDescription getConfigurationParameterDescription(String parName) {
        return null;
    }
    
}
