/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.config.CategoryDescription;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.SingleCategoryTag;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;

public class CategoryTagTest
extends CcsTestCaseTemplate {
    @Test
    public void testDefaultCategoryTag() throws Exception {
        SingleCategoryTag sourcedTag = new SingleCategoryTag("a1", "", "");
        String inputCategory = "";
        CategoryDescription tag = CategoryDescription.parseCategoryTagInput((String)inputCategory, (String)"a1");
        Assert.assertEquals((Object)"", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(sourcedTag));
        Assert.assertEquals((Object)"d", (Object)sourcedTag.getVersion());
        Assert.assertEquals((long)1L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)":{a1}(d)", (Object)tag.toString());
        sourcedTag = new SingleCategoryTag("s1", "", "");
        inputCategory = "{s1}";
        tag = CategoryDescription.parseCategoryTagInput((String)inputCategory, (String)"s1");
        Assert.assertEquals((Object)"", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(sourcedTag));
        Assert.assertEquals((Object)"d", (Object)tag.getSingleTagVersion(sourcedTag));
        Assert.assertEquals((long)1L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)":{s1}(d)", (Object)tag.toString());
        Assert.assertEquals((Object)"s1", (Object)sourcedTag.getSource());
        sourcedTag = new SingleCategoryTag("a1", "", "");
        inputCategory = ":";
        tag = CategoryDescription.parseCategoryTagInput((String)inputCategory, (String)"a1");
        Assert.assertEquals((Object)"", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(sourcedTag));
        Assert.assertEquals((Object)"d", (Object)tag.getSingleTagVersion(sourcedTag));
        Assert.assertEquals((long)1L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)":{a1}(d)", (Object)tag.toString());
        sourcedTag = new SingleCategoryTag("s23", "", "");
        inputCategory = ":{s23}";
        tag = CategoryDescription.parseCategoryTagInput((String)inputCategory, (String)"s23");
        Assert.assertEquals((Object)"", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(sourcedTag));
        Assert.assertEquals((Object)"d", (Object)tag.getSingleTagVersion(sourcedTag));
        Assert.assertEquals((long)1L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)":{s23}(d)", (Object)tag.toString());
        Assert.assertEquals((Object)"s23", (Object)sourcedTag.getSource());
        sourcedTag = new SingleCategoryTag("a1", "", "catA");
        inputCategory = "catA:";
        tag = CategoryDescription.parseCategoryTagInput((String)inputCategory, (String)"a1");
        Assert.assertEquals((Object)"catA", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(sourcedTag));
        Assert.assertEquals((Object)"d", (Object)tag.getSingleTagVersion(sourcedTag));
        Assert.assertEquals((long)1L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)"catA:{a1}(d)", (Object)tag.toString());
        sourcedTag = new SingleCategoryTag("sss22", "", "catA");
        inputCategory = "catA:{sss22}";
        tag = CategoryDescription.parseCategoryTagInput((String)inputCategory, (String)"sss22");
        Assert.assertEquals((Object)"catA", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(sourcedTag));
        Assert.assertEquals((Object)"d", (Object)tag.getSingleTagVersion(sourcedTag));
        Assert.assertEquals((long)1L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)"catA:{sss22}(d)", (Object)tag.toString());
        Assert.assertEquals((Object)"sss22", (Object)sourcedTag.getSource());
        sourcedTag = new SingleCategoryTag("a22", "tag1", "catA");
        inputCategory = "catA:tag1";
        tag = CategoryDescription.parseCategoryTagInput((String)inputCategory, (String)"a22");
        Assert.assertEquals((Object)"catA", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(sourcedTag));
        Assert.assertEquals((Object)"d", (Object)tag.getSingleTagVersion(sourcedTag));
        Assert.assertEquals((long)1L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)"catA:{a22}tag1(d)", (Object)tag.toString());
        sourcedTag = new SingleCategoryTag("S43", "tag1", "catA");
        inputCategory = "catA:{S43}tag1";
        tag = CategoryDescription.parseCategoryTagInput((String)inputCategory, (String)"sS43");
        Assert.assertEquals((Object)"catA", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(sourcedTag));
        Assert.assertEquals((Object)"d", (Object)tag.getSingleTagVersion(sourcedTag));
        Assert.assertEquals((long)1L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)(inputCategory + "(d)"), (Object)tag.toString());
        Assert.assertEquals((Object)"S43", (Object)sourcedTag.getSource());
        sourcedTag = new SingleCategoryTag("d45", "tag1", "catA");
        inputCategory = "catA:tag1(l)";
        tag = CategoryDescription.parseCategoryTagInput((String)inputCategory, (String)"d45");
        Assert.assertEquals((Object)"catA", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(sourcedTag));
        Assert.assertEquals((Object)"l", (Object)tag.getSingleTagVersion(sourcedTag));
        Assert.assertEquals((long)1L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)"catA:{d45}tag1(l)", (Object)tag.toString());
        sourcedTag = new SingleCategoryTag("d32", "tag1", "catA");
        inputCategory = "catA:{d32}tag1(l)";
        tag = CategoryDescription.parseCategoryTagInput((String)inputCategory, (String)"d32");
        Assert.assertEquals((Object)"catA", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(sourcedTag));
        Assert.assertEquals((Object)"l", (Object)tag.getSingleTagVersion(sourcedTag));
        Assert.assertEquals((long)1L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)inputCategory, (Object)tag.toString());
        Assert.assertEquals((Object)"d32", (Object)sourcedTag.getSource());
        SingleCategoryTag tag1 = new SingleCategoryTag("a23", "tag1", "catA");
        SingleCategoryTag tag2 = new SingleCategoryTag("a23", "tag2", "catA");
        inputCategory = "catA:tag1(123)|tag2(44)";
        tag = CategoryDescription.parseCategoryTagInput((String)inputCategory, (String)"a23");
        Assert.assertEquals((Object)"catA", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(tag1));
        Assert.assertEquals((Object)"123", (Object)tag.getSingleTagVersion(tag1));
        Assert.assertTrue((boolean)tag.containsSingleTag(tag2));
        Assert.assertEquals((Object)"44", (Object)tag.getSingleTagVersion(tag2));
        Assert.assertEquals((long)2L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)"catA:{a23}tag1(123)|{a23}tag2(44)", (Object)tag.toString());
        tag1 = new SingleCategoryTag("b2", "tag1", "catA");
        tag2 = new SingleCategoryTag("s123", "tag2", "catA");
        inputCategory = "catA:tag1(123)|{s123}tag2(44)";
        tag = CategoryDescription.parseCategoryTagInput((String)inputCategory, (String)"b2");
        Assert.assertEquals((Object)"catA", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(tag1));
        Assert.assertEquals((Object)"123", (Object)tag.getSingleTagVersion(tag1));
        Assert.assertTrue((boolean)tag.containsSingleTag(tag2));
        Assert.assertEquals((Object)"44", (Object)tag.getSingleTagVersion(tag2));
        Assert.assertEquals((long)2L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)"catA:{b2}tag1(123)|{s123}tag2(44)", (Object)tag.toString());
        Assert.assertEquals((Object)"s123", (Object)tag2.getSource());
        Assert.assertEquals((Object)"b2", (Object)tag1.getSource());
        tag1 = new SingleCategoryTag("a2", "tag1", "catA");
        tag2 = new SingleCategoryTag("a2", "tag2", "catA");
        SingleCategoryTag defaultTag = new SingleCategoryTag("a2", "", "catA");
        inputCategory = "catA:tag1(123)|tag2(44)|(d)";
        tag = CategoryDescription.parseCategoryTagInput((String)inputCategory, (String)"a2");
        Assert.assertEquals((Object)"catA", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(tag1));
        Assert.assertEquals((Object)"123", (Object)tag.getSingleTagVersion(tag1));
        Assert.assertTrue((boolean)tag.containsSingleTag(tag2));
        Assert.assertEquals((Object)"44", (Object)tag.getSingleTagVersion(tag2));
        Assert.assertTrue((boolean)tag.containsSingleTag(defaultTag));
        Assert.assertEquals((Object)"d", (Object)tag.getSingleTagVersion(defaultTag));
        Assert.assertEquals((long)3L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)"catA:{a2}tag1(123)|{a2}tag2(44)|{a2}(d)", (Object)tag.toString());
        tag1 = new SingleCategoryTag("g", "tag1", "catA");
        tag2 = new SingleCategoryTag("d", "tag2", "catA");
        defaultTag = new SingleCategoryTag("s56", "", "catA");
        inputCategory = "catA:{g}tag1(123)|tag2(44)|{s56}(d)";
        tag = CategoryDescription.parseCategoryTagInput((String)inputCategory, (String)"d");
        Assert.assertEquals((Object)"catA", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(tag1));
        Assert.assertEquals((Object)"123", (Object)tag.getSingleTagVersion(tag1));
        Assert.assertTrue((boolean)tag.containsSingleTag(tag2));
        Assert.assertEquals((Object)"44", (Object)tag.getSingleTagVersion(tag2));
        Assert.assertTrue((boolean)tag.containsSingleTag(defaultTag));
        Assert.assertEquals((Object)"d", (Object)tag.getSingleTagVersion(defaultTag));
        Assert.assertEquals((long)3L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)"catA:{g}tag1(123)|{d}tag2(44)|{s56}(d)", (Object)tag.toString());
        Assert.assertEquals((Object)"g", (Object)tag1.getSource());
        Assert.assertEquals((Object)"d", (Object)tag2.getSource());
        Assert.assertEquals((Object)"s56", (Object)defaultTag.getSource());
        SingleCategoryTag tagA = new SingleCategoryTag("a2", "tagA", "");
        inputCategory = "tagA";
        tag = CategoryDescription.parseCategoryTagInput((String)inputCategory, (String)"a2");
        Assert.assertEquals((Object)"", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsSingleTag(tagA));
        Assert.assertEquals((Object)":{a2}tagA(d)", (Object)tag.toString());
        try {
            tag = CategoryDescription.parseCategoryTagInput((String)"catA:tag1(123)|tag2(44)|tag1(d)", (String)"ccc");
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testConfigurationDescription() throws Exception {
        String configDescriptionStr = "[:{s1}(d)|{s5}tag1(d)*,build:{s8}defaultInitial(d),catA:{s9}(d)|{s1}tag2(d)*,catB:{s1}defaultInitial(d),timers:{s8}defaultInitial(d)]";
        HashSet<String> allCategories = new HashSet<String>();
        allCategories.add("");
        allCategories.add("build");
        allCategories.add("catA");
        allCategories.add("catB");
        allCategories.add("timers");
        ConfigurationInfo.Builder builder = new ConfigurationInfo.Builder();
        ConfigurationInfo ci = builder.updateConfigurationDescription(configDescriptionStr).build();
        ConfigurationDescription cd = ConfigurationDescription.fromConfigurationInfo((ConfigurationInfo)ci, allCategories, (String)"alias1");
        Assert.assertEquals((Object)configDescriptionStr, (Object)cd.getDescriptionName());
    }

    @Test
    public void testConfigurationDescriptionWithSource() throws Exception {
        String configDescriptionStr = "[:{s0}(d)|{s1}tag1(d)*,build:{s2}defaultInitial(d),catA:{s6}(d)|{s2}tag2(d)*,catB:{s6}defaultInitial(d),timers:{s5}defaultInitial(d)]";
        HashSet<String> allCategories = new HashSet<String>();
        allCategories.add("");
        allCategories.add("build");
        allCategories.add("catA");
        allCategories.add("catB");
        allCategories.add("timers");
        ConfigurationInfo.Builder builder = new ConfigurationInfo.Builder();
        ConfigurationInfo ci = builder.updateConfigurationDescription(configDescriptionStr).build();
        ConfigurationDescription cd = ConfigurationDescription.fromConfigurationInfo((ConfigurationInfo)ci, allCategories, (String)"alias2");
        Assert.assertEquals((Object)configDescriptionStr, (Object)cd.getDescriptionName());
    }
}

