/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.Set;
import org.lsst.ccs.config.FileWriterProvider;
import org.lsst.ccs.config.InMemoryWriterProvider;
import org.lsst.ccs.config.WriterProvider;

class InMemoryFileWriterProvider
extends WriterProvider {
    private final WriterProvider inMemoryWriterProvider;
    private final WriterProvider fileWriterProvider;
    public static boolean ALWAYS_FIND_FILENAME = true;

    InMemoryFileWriterProvider() {
        this(new InMemoryWriterProvider(), new FileWriterProvider());
    }

    InMemoryFileWriterProvider(InMemoryWriterProvider inMemoryWriterProvider, FileWriterProvider fileWriterProvider) {
        this.inMemoryWriterProvider = inMemoryWriterProvider;
        this.fileWriterProvider = fileWriterProvider;
    }

    public PrintWriter getPrintWriter(String fileName) throws IOException {
        return this.inMemoryWriterProvider.getPrintWriter(fileName);
    }

    public Properties getProperties(String fileName) throws IOException {
        Properties props = this.inMemoryWriterProvider.getProperties(fileName);
        if (props == null) {
            Properties fileProps = this.fileWriterProvider.getProperties(fileName);
            if (fileProps == null) {
                if (ALWAYS_FIND_FILENAME) {
                    return new Properties();
                }
                return null;
            }
            PrintWriter printW = this.getPrintWriter(fileName);
            String comments = "Properties loaded from file " + fileName;
            fileProps.store(printW, comments);
            props = fileProps;
        }
        return props;
    }

    Set<String> findMatchingPropertiesFiles(String pattern) {
        Set foundFiles = this.fileWriterProvider.findMatchingPropertiesFiles(pattern);
        Set foundInMemory = this.inMemoryWriterProvider.findMatchingPropertiesFiles(pattern);
        foundFiles.addAll(foundInMemory);
        return foundFiles;
    }

    String locateFile(String fileName) {
        return this.inMemoryWriterProvider.locateFile(fileName);
    }
}

