/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.config.remote;

import java.util.Set;
import java.util.concurrent.TimeUnit;

import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.config.ConfigurationDAO;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceManager;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.utilities.logging.Logger;

/**
 * Implementation of the remote configuration proxy, through the CCS Buses. It
 * interacts with the server side configuration system through the CCS Buses
 * 
 * @author LSST CCS Team
 */
public class CCSBusesConfigurationDAO implements ConfigurationDAO {

    private final AgentPresenceManager apm;

    private final ConcurrentMessagingUtils cmu;

    private static final String DB_NAME = "localdb/configuration-server";
    
    Logger log = Logger.getLogger("org.lsst.ccs.config");
    
    private final String agentName;
    private final String sourceName;


    public CCSBusesConfigurationDAO(AgentMessagingLayer aml, String sourceName) {
        cmu = new ConcurrentMessagingUtils(aml);

        apm = aml.getAgentPresenceManager();

        agentName = aml.getAgentInfo().getName();
        this.sourceName = sourceName;
        
        log.debug("instanciated CCSBusesConfigurationDAO");

    }
    
    private void waitForService() {
        try {
            apm.waitForAgent(DB_NAME, 10, TimeUnit.SECONDS);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ConfigurationDescription saveChangesForCategoriesAs(ConfigurationDescription configDesc,
            ConfigurationInfo configInfo) throws ConfigurationServiceException {
        return registerConfiguration(configInfo);
    }

    @Override
    public ConfigurationView loadConfiguration(ConfigurationDescription configDesc)
            throws ConfigurationServiceException {
        try {
            log.debug("loadConfiguration "+agentName+" "+configDesc);
            log.debug("remote loadconfig desc tags "+configDesc.getCategoriesSet());
            waitForService();
            log.debug("sending command " + agentName + " " + configDesc);

            return (ConfigurationView) cmu
                    .sendSynchronousCommand(new CommandRequest(DB_NAME, "loadConfigurationForSource", sourceName, configDesc));
        } catch (Exception ex) {
            ex.printStackTrace();
            throw new ConfigurationServiceException("remote configuration error", ex);
        }
    }

    @Override
    public ConfigurationView loadGlobalConfiguration(String name, int version) {
        try {
            log.debug("loadGlobalConfiguration "+agentName+" "+name+" "+version);
            return (ConfigurationView) cmu.sendSynchronousCommand(
                    new CommandRequest(DB_NAME, "loadGlobalConfigurationForSource", sourceName, name, version));
        } catch (Exception ex) {
            ex.printStackTrace();
            throw new ConfigurationServiceException("remote configuration error", ex);
        }
    }

    @Override
    public Set<String> findAvailableConfigurationsForCategory(String category) {
        return null;
    }

    @Override
    public boolean isAvailable() {
        return apm.agentExists("localdb");
    }

    @Override
    public ConfigurationDescription registerConfiguration(ConfigurationInfo configInfo)
            throws ConfigurationServiceException {
        try {
            log.debug("registerConfiguration "+agentName+" "+configInfo);
            return (ConfigurationDescription) cmu.sendSynchronousCommand(
                    new CommandRequest(DB_NAME, "registerConfigurationForSource", sourceName, configInfo));
        } catch (Exception ex) {
            ex.printStackTrace();
            throw new ConfigurationServiceException("remote configuration error", ex);
        }
    }
}
