/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationWriterProvider;

public class ConfigurationFileNameTest {
    @Test
    public void testConfigFileNames() {
        Assert.assertEquals((String)"configuration file name ", (Object)"descriptionName.properties", (Object)new ConfigurationWriterProvider.ConfigurationFileName("descriptionName", "", "").getFullName());
        Assert.assertEquals((String)"configuration file name ", (Object)"descriptionName_config.properties", (Object)new ConfigurationWriterProvider.ConfigurationFileName("descriptionName", "config", "").getFullName());
    }

    @Test
    public void testConfigInput() {
        HashSet<String> cats = new HashSet<String>();
        cats.add("");
        cats.add("catA");
        cats.add("catB");
        ConfigurationDescription cd = new ConfigurationDescription(cats).parseConfigurationString(new String[]{""});
        Assert.assertEquals((Object)"", cd.getCategoryTags().get(""));
        Assert.assertNull(cd.getCategoryTags().get("catA"));
        Assert.assertNull(cd.getCategoryTags().get("catB"));
        Assert.assertEquals((long)-1L, (long)((Integer)cd.getCategoryVersions().get("")).intValue());
        Assert.assertNull(cd.getCategoryTags().get("catA"));
        Assert.assertNull(cd.getCategoryTags().get("catB"));
        cd.withDefaults(true);
        Assert.assertEquals((Object)"", cd.getCategoryTags().get(""));
        Assert.assertEquals((Object)"", cd.getCategoryTags().get("catA"));
        Assert.assertEquals((Object)"", cd.getCategoryTags().get("catB"));
        Assert.assertEquals((long)-1L, (long)((Integer)cd.getCategoryVersions().get("")).intValue());
        Assert.assertEquals((long)-1L, (long)((Integer)cd.getCategoryVersions().get("catA")).intValue());
        Assert.assertEquals((long)-1L, (long)((Integer)cd.getCategoryVersions().get("catB")).intValue());
        cd = new ConfigurationDescription(cats).parseConfigurationString(new String[]{"catA:configA(3)"});
        Assert.assertEquals((Object)"configA", cd.getCategoryTags().get("catA"));
        Assert.assertEquals((long)3L, (long)((Integer)cd.getCategoryVersions().get("catA")).intValue());
        cd = new ConfigurationDescription(cats).parseConfigurationString(new String[]{"catA:"});
        Assert.assertEquals((Object)"", cd.getCategoryTags().get("catA"));
        Assert.assertEquals((long)-1L, (long)((Integer)cd.getCategoryVersions().get("catA")).intValue());
        cd = new ConfigurationDescription(cats).parseConfigurationString(new String[]{"configD1"});
        Assert.assertEquals((Object)"configD1", cd.getCategoryTags().get(""));
        Assert.assertEquals((long)-1L, (long)((Integer)cd.getCategoryVersions().get("")).intValue());
        cd = new ConfigurationDescription(cats).parseConfigurationString(new String[]{"configD2(17)"});
        Assert.assertEquals((Object)"configD2", cd.getCategoryTags().get(""));
        Assert.assertEquals((long)17L, (long)((Integer)cd.getCategoryVersions().get("")).intValue());
        cd = new ConfigurationDescription(cats).parseConfigurationString(new String[]{"configD2()"});
        Assert.assertEquals((Object)"configD2", cd.getCategoryTags().get(""));
        Assert.assertEquals((long)-1L, (long)((Integer)cd.getCategoryVersions().get("")).intValue());
        cd = new ConfigurationDescription(cats).parseConfigurationString(new String[]{"configD2(l)"});
        Assert.assertEquals((Object)"configD2", cd.getCategoryTags().get(""));
        Assert.assertEquals((long)-2L, (long)((Integer)cd.getCategoryVersions().get("")).intValue());
        cd = new ConfigurationDescription(cats).parseConfigurationString(new String[]{"configD2(d)"});
        Assert.assertEquals((Object)"configD2", cd.getCategoryTags().get(""));
        Assert.assertEquals((long)-1L, (long)((Integer)cd.getCategoryVersions().get("")).intValue());
        cd = new ConfigurationDescription(cats).parseConfigurationString(new String[]{":(17)"});
        Assert.assertEquals((Object)"", cd.getCategoryTags().get(""));
        Assert.assertEquals((long)17L, (long)((Integer)cd.getCategoryVersions().get("")).intValue());
    }
}

