package org.lsst.ccs.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

/**
 * Reads and Writes properties files from/to a FileSystem, using 
 *
 * @author LSST CCS Team
 */
class FileWriterProvider extends WriterProvider {

    private static final java.util.logging.Logger LOG = Logger.getLogger(FileWriterProvider.class.getName());
    
    @Override
    public PrintWriter getPrintWriter(String fileName) throws IOException {
        String tmpFileName = fileName;
        //Check if the properties file already exists in the Bootstrap Environment
        String pathInBootstrap = BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories(fileName);
        //If it does not exist...
        if (pathInBootstrap == null) {
            // then check if a there is a Bootstrap user defined directory in which to write it.
            String topMostUserDirectory = BootstrapResourceUtils.getTopUserResourceDirectory();
            //If there is not Bootstrap user Directory defined.....
            if (topMostUserDirectory == null) {
                throw new RuntimeException("There is no external resource directory in which to write the file. Please make sure to"
                        + " define one using environment variable CCS_RESOURCE_PATH.");
            } else {
                fileName = topMostUserDirectory + fileName;
            }
        } else {
            fileName = pathInBootstrap;
        }

        LOG.log(Level.INFO, "Saving {0} to {1}", new Object[]{tmpFileName, fileName});
 
        return new PrintWriter(fileName, "ISO-8859-1");
    }

    @Override
    public Properties getProperties(String fileName) throws IOException {
        Properties configProps = new Properties();
        InputStream propsIs = null;
        propsIs = BootstrapResourceUtils.getBootstrapResource(fileName);
        if (propsIs == null) { // The resource could not be found
            return null;
        }
        LOG.log(Level.INFO, "Found configuration file : {0}", BootstrapResourceUtils.getResourceURL(fileName).getPath());
        configProps.load(propsIs);
        return configProps;
    }

    @Override
    Set<String> findMatchingPropertiesFiles(String pattern) {
        return BootstrapResourceUtils.findMatchingResources(pattern);
    }

    @Override
    String locateFile(String fileName) {
        return BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories(fileName);
    }
}
