/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.Map;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;

public class BulkChangeComponent
implements ConfigurationBulkChangeHandler {
    private int nBulkValidationCalls = 0;
    private int nBulkSettingCalls = 0;
    @ConfigurationParameter(isOptional=true)
    private volatile String info = "";
    @ConfigurationParameter(isOptional=true)
    private volatile int min = 0;
    @ConfigurationParameter(isOptional=true)
    private volatile int max = 10;
    @ConfigurationParameter(isOptional=true)
    private volatile double value = 3.14;
    @ConfigurationParameter(isOptional=true)
    protected volatile String hiddenParm = "init";
    @ConfigurationParameter(isFinal=true, isOptional=true)
    protected volatile String thisIsFinal = "thisIsFinal";
    private int nSetIsFinal = 0;
    private int nValidate;
    private int nSet;
    @ConfigurationParameter(isReadOnly=true, isOptional=true)
    protected volatile String readOnlyPar = "ver";
    private boolean spuriousValidation = false;
    private boolean spuriousSetting = false;

    public String getInfo() {
        return this.info;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public double getValue() {
        return this.value;
    }

    public void setSpuriousValidation(boolean b) {
        this.spuriousValidation = b;
    }

    public void setSpuriousSetting(boolean b) {
        this.spuriousSetting = b;
    }

    @ConfigurationParameterChanger
    public void setValue(double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException("no negative value");
        }
        this.value = value;
    }

    @ConfigurationParameterChanger
    public void setInfo(String info) {
        this.info = info;
    }

    public void validateBulkChange(Map<String, Object> parametersView) {
        int theMax;
        ++this.nBulkValidationCalls;
        this.nValidate = parametersView.size();
        int theMin = (Integer)parametersView.get("min");
        if (theMin > (theMax = ((Integer)parametersView.get("max")).intValue())) {
            throw new IllegalArgumentException("min greater than max");
        }
        if (this.spuriousValidation) {
            this.value *= 2.0;
        }
        if (!parametersView.containsKey("thisIsFinal")) {
            throw new RuntimeException("This map should have had the final parameter");
        }
    }

    public void setParameterBulk(Map<String, Object> parametersView) {
        Object obj;
        ++this.nBulkSettingCalls;
        this.nSet = parametersView.size();
        if (parametersView.containsKey("thisIsFinal")) {
            ++this.nSetIsFinal;
        }
        if ((obj = parametersView.remove("max")) != null) {
            int theMax = (Integer)obj;
            if (theMax > 100) {
                throw new IllegalArgumentException("exception at setting step : max cannot be greter than 100");
            }
            this.max = theMax;
        }
        if ((obj = parametersView.remove("min")) != null) {
            int theMin = (Integer)obj;
            if (theMin < 0) {
                throw new IllegalArgumentException("exception at setting step : min cannot be negative");
            }
            this.min = (Integer)obj;
        }
        if (this.spuriousSetting) {
            this.hiddenParm = "changed";
            this.min *= 2;
        }
    }

    public Object[] getConfValues() {
        return new Object[]{this.info, this.min, this.max, this.value};
    }

    public int getNumberOfBulkValidationCalls() {
        return this.nBulkValidationCalls;
    }

    public int getNumberOfBulkSettingCalls() {
        return this.nBulkSettingCalls;
    }

    public int getNumberOfValidatedParameters() {
        return this.nValidate;
    }

    public int getNumberOfSetParameters() {
        return this.nSet;
    }

    public int getNumberOfSetIsFinal() {
        return this.nSetIsFinal;
    }
}

