/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.config.LocalConfigurationDAO;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;

public class LocalConfigurationDAOTest
extends CcsTestCaseTemplate {
    private Set<String> categories = new HashSet<String>();

    @Before
    public void initTest() {
        this.categories.add("");
        this.categories.add("catA");
        this.categories.add("catB");
    }

    @Test
    public void testFindAvailableConfigurations() throws Exception {
        LocalConfigurationDAO proxyDesc1 = new LocalConfigurationDAO("desc1");
        LocalConfigurationDAO proxyDesc11 = new LocalConfigurationDAO("desc11");
        Set res = proxyDesc1.findAvailableConfigurationsForCategory("catA");
        res.addAll(proxyDesc11.findAvailableConfigurationsForCategory("catA"));
        Assert.assertEquals((long)2L, (long)res.size());
        Assert.assertTrue((boolean)res.contains("configA1"));
        Assert.assertTrue((boolean)res.contains(""));
        res = proxyDesc1.findAvailableConfigurationsForCategory("catB");
        res.addAll(proxyDesc11.findAvailableConfigurationsForCategory("catB"));
        Assert.assertEquals((long)1L, (long)res.size());
        Assert.assertTrue((boolean)res.contains("configB2"));
        LocalConfigurationDAO proxyDesc2 = new LocalConfigurationDAO("desc2");
        LocalConfigurationDAO proxyDesc21 = new LocalConfigurationDAO("desc21");
        res = proxyDesc2.findAvailableConfigurationsForCategory("");
        res.addAll(proxyDesc21.findAvailableConfigurationsForCategory("catB"));
        Assert.assertEquals((long)3L, (long)res.size());
        Assert.assertTrue((boolean)res.contains("configD1"));
        Assert.assertTrue((boolean)res.contains("configD2"));
        Assert.assertTrue((boolean)res.contains(""));
    }

    @Test
    public void testLoadNamedConfiguration() throws Exception {
        LocalConfigurationDAO proxyDesc1 = new LocalConfigurationDAO("desc1");
        LocalConfigurationDAO proxyDesc11 = new LocalConfigurationDAO("desc11");
        ConfigurationDescription configDesc = new ConfigurationDescription(this.categories).parseConfigurationString(new String[]{"catA:configA1", "catB:configB2", ":def1"});
        ConfigurationView cv1 = null;
        try {
            proxyDesc11.loadConfiguration(configDesc);
        }
        catch (Exception exception) {
            // empty catch block
        }
        cv1 = proxyDesc1.loadConfiguration(configDesc);
        configDesc.setName("GLOBAL_NAME", -1);
        ConfigurationView cv2 = null;
        try {
            proxyDesc11.loadGlobalConfiguration("GLOBAL_NAME", -1);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        cv2 = proxyDesc1.loadGlobalConfiguration("GLOBAL_NAME", -1);
        Assert.assertTrue((boolean)cv1.diff(cv2).isEmpty());
        Assert.assertTrue((boolean)cv2.diff(cv1).isEmpty());
    }
}

