/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationWriterProvider;

public class ConfigurationFileNameTest {
    @Test
    public void testConfigFileNames() {
        Assert.assertEquals((String)"configuration file name ", (Object)"descriptionName.properties", (Object)new ConfigurationWriterProvider.ConfigurationFileName("descriptionName", "", "").getFullName());
        Assert.assertEquals((String)"configuration file name ", (Object)"descriptionName_config.properties", (Object)new ConfigurationWriterProvider.ConfigurationFileName("descriptionName", "config", "").getFullName());
    }

    @Test
    public void testConfigInput() {
        HashSet<String> cats = new HashSet<String>();
        cats.add("");
        cats.add("catA");
        cats.add("catB");
        ConfigurationDescription cd = new ConfigurationDescription(cats).parseConfigurationString(new String[]{""});
        Assert.assertTrue((boolean)cd.getCategoryTag("").containsTag(""));
        Assert.assertNull((Object)cd.getCategoryTag("catA"));
        Assert.assertNull((Object)cd.getCategoryTag("catB"));
        Assert.assertEquals((long)-1L, (long)cd.getCategoryTag("").getTagVersion("").intValue());
        cd.withDefaults(true);
        Assert.assertTrue((boolean)cd.getCategoryTag("").containsTag(""));
        Assert.assertTrue((boolean)cd.getCategoryTag("catA").containsTag(""));
        Assert.assertTrue((boolean)cd.getCategoryTag("catB").containsTag(""));
        Assert.assertEquals((long)-1L, (long)cd.getCategoryTag("").getTagVersion("").intValue());
        Assert.assertEquals((long)-1L, (long)cd.getCategoryTag("catA").getTagVersion("").intValue());
        Assert.assertEquals((long)-1L, (long)cd.getCategoryTag("catB").getTagVersion("").intValue());
        cd = new ConfigurationDescription(cats).parseConfigurationString(new String[]{"catA:configA(3)"});
        Assert.assertTrue((boolean)cd.getCategoryTag("catA").containsTag("configA"));
        Assert.assertEquals((long)3L, (long)cd.getCategoryTag("catA").getTagVersion("configA").intValue());
        cd = new ConfigurationDescription(cats).parseConfigurationString(new String[]{"catA:"});
        Assert.assertTrue((boolean)cd.getCategoryTag("catA").containsTag(""));
        Assert.assertEquals((long)-1L, (long)cd.getCategoryTag("catA").getTagVersion("").intValue());
        cd = new ConfigurationDescription(cats).parseConfigurationString(new String[]{"configD1"});
        Assert.assertTrue((boolean)cd.getCategoryTag("").containsTag("configD1"));
        Assert.assertEquals((long)-1L, (long)cd.getCategoryTag("").getTagVersion("configD1").intValue());
        cd = new ConfigurationDescription(cats).parseConfigurationString(new String[]{"configD2(17)"});
        Assert.assertTrue((boolean)cd.getCategoryTag("").containsTag("configD2"));
        Assert.assertEquals((long)17L, (long)cd.getCategoryTag("").getTagVersion("configD2").intValue());
        cd = new ConfigurationDescription(cats).parseConfigurationString(new String[]{"configD2()"});
        Assert.assertTrue((boolean)cd.getCategoryTag("").containsTag("configD2"));
        Assert.assertEquals((long)-1L, (long)cd.getCategoryTag("").getTagVersion("configD2").intValue());
        cd = new ConfigurationDescription(cats).parseConfigurationString(new String[]{"configD2(l)"});
        Assert.assertTrue((boolean)cd.getCategoryTag("").containsTag("configD2"));
        Assert.assertEquals((long)-2L, (long)cd.getCategoryTag("").getTagVersion("configD2").intValue());
        cd = new ConfigurationDescription(cats).parseConfigurationString(new String[]{"configD2(d)"});
        Assert.assertTrue((boolean)cd.getCategoryTag("").containsTag("configD2"));
        Assert.assertEquals((long)-1L, (long)cd.getCategoryTag("").getTagVersion("configD2").intValue());
        cd = new ConfigurationDescription(cats).parseConfigurationString(new String[]{":(17)"});
        Assert.assertTrue((boolean)cd.getCategoryTag("").containsTag(""));
        Assert.assertEquals((long)17L, (long)cd.getCategoryTag("").getTagVersion("").intValue());
    }
}

