/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.config.BulkChangeComponent;
import org.lsst.ccs.config.BulkSettingException;
import org.lsst.ccs.config.BulkValidationException;
import org.lsst.ccs.config.ChangeList;
import org.lsst.ccs.config.ConfigurationHandlerSet;
import org.lsst.ccs.config.ConfigurationParameterHandler;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;

public class ConfigurationBulkChangesTest
extends CcsTestCaseTemplate {
    private static final Map<String, BulkChangeComponent> comps = new LinkedHashMap<String, BulkChangeComponent>();
    private static final String tag = "withBulkSetting";
    private ConfigurationHandlerSet chs;
    private final Object[] changesOK = new Object[]{"OK", 3, 8, 6.28};
    private final Object[] changesValNOK = new Object[]{"NOK", 8, 6, 6.28};
    private final Object[] changesSettingMaxNOK = new Object[]{"NOK", 8, 101, 6.28};
    private final Object[] changesSettingMinNOK = new Object[]{"NOK", -10, 60, 6.28};
    private Object[] initVals;

    @Before
    public void initAgents() throws Exception {
        comps.put("main", new BulkChangeComponent());
        comps.put("son1", new BulkChangeComponent());
        comps.put("son2", new BulkChangeComponent());
        this.chs = new ConfigurationHandlerSet();
        for (Map.Entry<String, BulkChangeComponent> entry : comps.entrySet()) {
            this.chs.addConfigurationHandlerForObject(entry.getKey(), entry.getKey(), (Object)entry.getValue());
        }
        this.chs.initializeConfiguration(tag);
        this.initVals = comps.get("main").getConfValues();
    }

    @Test
    public void testCommitBulkChangesFailsAtValidation() throws Exception {
        ChangeList changes = new ChangeList();
        this.addChanges(changes, "main", this.changesOK);
        this.addChanges(changes, "son1", this.changesValNOK);
        this.addChanges(changes, "son2", this.changesOK);
        try {
            this.chs.commitBulkChange(changes, null);
            Assert.fail();
        }
        catch (BulkValidationException ex) {
            for (String key : comps.keySet()) {
                int numChanges = changes.filteredBy(ChangeList.forComponentNamed((String)key)).size();
                Assert.assertEquals((String)("Some changes were dropped for component " + key), (long)4L, (long)numChanges);
            }
            Assert.assertTrue((String)ex.getCause().getMessage(), (boolean)ex.getCause().getMessage().toLowerCase().contains("min greater than max"));
        }
        for (String key : comps.keySet()) {
            Assert.assertArrayEquals((String)("Values should not have changed for component " + key), (Object[])this.initVals, (Object[])comps.get(key).getConfValues());
        }
    }

    @Test
    public void testCommitBulkChangesSucceeds() throws Exception {
        ChangeList changes = new ChangeList();
        this.addChanges(changes, "son1", this.changesOK);
        this.addChanges(changes, "son2", this.changesOK);
        this.addChanges(changes, "main", this.changesOK);
        this.chs.commitBulkChange(changes, null);
        Assert.assertArrayEquals((String)"Some changes weren't made for component main", (Object[])this.changesOK, (Object[])comps.get("main").getConfValues());
        Assert.assertArrayEquals((String)"Some changes weren't made for component son1", (Object[])this.changesOK, (Object[])comps.get("son1").getConfValues());
        Assert.assertArrayEquals((String)"Some changes weren't made for component son2", (Object[])this.changesOK, (Object[])comps.get("son2").getConfValues());
    }

    @Test
    public void testCommitBulkChangesFailsAtBulkSetting() throws Exception {
        ChangeList changes = new ChangeList();
        this.addChanges(changes, "main", this.changesOK);
        this.addChanges(changes, "son1", this.changesSettingMaxNOK);
        this.addChanges(changes, "son2", this.changesOK);
        try {
            this.chs.commitBulkChange(changes, null);
            Assert.fail((String)"An exception should have been thrown");
        }
        catch (BulkSettingException ex) {
            Throwable cause = ex.getCause();
            Assert.assertTrue((boolean)(cause instanceof IllegalArgumentException));
        }
        Assert.assertArrayEquals((String)"Should have been set for component main", (Object[])this.changesOK, (Object[])comps.get("main").getConfValues());
        Assert.assertArrayEquals((String)"Nothing should have been changed for component son1", (Object[])this.initVals, (Object[])comps.get("son1").getConfValues());
        Assert.assertArrayEquals((String)"Nothing should have been changed for component son2", (Object[])this.initVals, (Object[])comps.get("son2").getConfValues());
    }

    @Test
    public void testCommitBulkChangesFailsHalfwayAtBulkSetting() throws Exception {
        ChangeList changes = new ChangeList();
        this.addChanges(changes, "son1", this.changesSettingMinNOK);
        try {
            this.chs.commitBulkChange(changes, null);
            Assert.fail((String)"An exception should have been thrown");
        }
        catch (BulkSettingException ex) {
            Throwable cause = ex.getCause();
            Assert.assertTrue((boolean)(cause instanceof IllegalArgumentException));
            Assert.assertTrue((String)cause.getMessage(), (boolean)cause.getMessage().toLowerCase().contains("min cannot be negative"));
        }
        BulkChangeComponent son1 = comps.get("son1");
        Assert.assertEquals((long)0L, (long)son1.getMin());
        Assert.assertEquals((long)60L, (long)son1.getMax());
        Assert.assertEquals((double)3.14, (double)son1.getValue(), (double)0.0);
    }

    @Test
    public void testSpuriousChangeAtValidationStep() throws Exception {
        ChangeList changes = new ChangeList();
        this.addChanges(changes, "main", this.changesOK);
        this.addChanges(changes, "son1", this.changesOK);
        this.addChanges(changes, "son2", this.changesOK);
        BulkChangeComponent son1 = comps.get("son1");
        son1.setSpuriousValidation(true);
        try {
            this.chs.commitBulkChange(changes, null);
            Assert.fail();
        }
        catch (BulkSettingException ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)ex.getMessage().toLowerCase().contains("son1/value"));
        }
        Assert.assertArrayEquals((String)"Values should not have changed for component main", (Object[])this.initVals, (Object[])comps.get("main").getConfValues());
        Assert.assertArrayEquals((String)"Only one value should have changed for component son1", (Object[])new Object[]{"", 0, 10, 6.28}, (Object[])comps.get("son1").getConfValues());
        Assert.assertArrayEquals((String)"Values should not have changed for component son2", (Object[])this.initVals, (Object[])comps.get("son2").getConfValues());
    }

    @Test
    public void testSpuriousChangeAtSettingStep() throws Exception {
        ChangeList changes = new ChangeList();
        this.addChanges(changes, "main", this.changesOK);
        this.addChanges(changes, "son1", this.changesOK);
        this.addChanges(changes, "son2", this.changesOK);
        BulkChangeComponent son1 = comps.get("son1");
        son1.setSpuriousSetting(true);
        try {
            this.chs.commitBulkChange(changes, null);
            Assert.fail();
        }
        catch (BulkSettingException ex) {
            ex.printStackTrace();
            Assert.assertTrue((String)ex.getCause().getMessage(), (boolean)ex.getCause().getMessage().toLowerCase().contains("had neither its old value"));
        }
        Assert.assertArrayEquals((String)"Values were not correctly set for component main", (Object[])this.changesOK, (Object[])comps.get("main").getConfValues());
        Assert.assertArrayEquals((String)"Component son1 has spurious changes", (Object[])new Object[]{"", 6, 8, 3.14}, (Object[])comps.get("son1").getConfValues());
        Assert.assertArrayEquals((String)"Values should not have changed for component son2", (Object[])this.initVals, (Object[])comps.get("son2").getConfValues());
    }

    private void addChanges(ChangeList changes, String component, Object[] values) {
        String[] params = new String[]{"info", "min", "max", "value"};
        for (int i = 0; i < params.length; ++i) {
            ConfigurationParameterHandler cph = this.chs.getParameterHandler(component, params[i]);
            changes.addChange(cph, values[i]);
        }
    }
}

