/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.config.AnnotatedClass;
import org.lsst.ccs.config.BulkSettingException;
import org.lsst.ccs.config.BulkValidationException;
import org.lsst.ccs.config.ChangeList;
import org.lsst.ccs.config.ConfigurationHandlerSet;
import org.lsst.ccs.config.ConfigurationParameterHandler;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;

public class ConfigurationATest
extends CcsTestCaseTemplate {
    private static final String tag = "validationTest";
    private ConfigurationHandlerSet chs;
    private AnnotatedClass component;

    @Before
    public void initAgents() throws Exception {
        this.chs = new ConfigurationHandlerSet();
        this.component = new AnnotatedClass();
        this.chs.addConfigurationHandlerForObject("someName", "someName", (Object)this.component);
        this.chs.initializeConfiguration(tag);
    }

    @Test
    public void testFinalParameterModification() {
        try {
            ChangeList changes = new ChangeList();
            this.addChange(changes, "someName", "finalString", "newValue");
            this.chs.commitBulkChange(changes, null);
            Assert.fail();
        }
        catch (BulkValidationException ex) {
            Throwable cause = ex.getCause();
            Assert.assertTrue((boolean)(cause instanceof IllegalStateException));
            Assert.assertTrue((boolean)cause.getMessage().toLowerCase().contains("not modifiable at runtime"));
        }
    }

    @Test
    public void testConstraintRangeCheck() {
        Throwable cause;
        ChangeList changes;
        try {
            changes = new ChangeList();
            this.addChange(changes, "someName", "annotatedDouble", -1);
            this.chs.commitBulkChange(changes, null);
            Assert.fail();
        }
        catch (BulkValidationException ex) {
            cause = ex.getCause();
            Assert.assertTrue((String)cause.getClass().getSimpleName(), (boolean)(cause instanceof IllegalArgumentException));
            Assert.assertTrue((boolean)cause.getMessage().toLowerCase().contains("range"));
        }
        try {
            changes = new ChangeList();
            this.addChange(changes, "someName", "annotatedDouble", -1);
            this.addChange(changes, "someName", "parm2", 0);
            this.chs.commitBulkChange(changes, null);
            Assert.fail();
        }
        catch (BulkValidationException ex) {
            cause = ex.getCause();
            Assert.assertTrue((boolean)(cause instanceof IllegalArgumentException));
            Assert.assertTrue((boolean)cause.getMessage().toLowerCase().contains("range"));
        }
    }

    @Test
    public void testConfigChangerSetterFails() {
        try {
            ChangeList changes = new ChangeList();
            this.addChange(changes, "someName", "annotatedDouble", 0);
            this.addChange(changes, "someName", "parm2", -1);
            this.chs.commitBulkChange(changes, null);
            Assert.fail();
        }
        catch (BulkSettingException ex) {
            Assert.assertTrue((boolean)ex.getMessage().toLowerCase().contains("negative values"));
        }
    }

    @Test
    public void testMapSetting1() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("min", 20);
        map.put("max", 97);
        try {
            ChangeList changes = new ChangeList();
            this.addChange(changes, "someName", "annotatedMap", map);
            this.chs.commitBulkChange(changes, null);
            Map<String, Integer> newMap = this.component.getMap();
            Assert.assertEquals(map, newMap);
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testMapSetting2() {
        try {
            ChangeList changes = new ChangeList();
            this.addChange(changes, "someName", "annotatedMap", "[min:13,max:41]");
            this.chs.commitBulkChange(changes, null);
            Map<String, Integer> newMap = this.component.getMap();
            Assert.assertEquals((long)2L, (long)newMap.size());
            Assert.assertEquals((Object)13, (Object)newMap.get("min"));
            Assert.assertEquals((Object)41, (Object)newMap.get("max"));
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    private void addChange(ChangeList changes, String componentName, String paramName, Object value) {
        ConfigurationParameterHandler cph = this.chs.getParameterHandler(componentName, paramName);
        changes.addChange(cph, value);
    }
}

