/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;
import org.lsst.ccs.config.SuperAnnotatedClass;

public class AnnotatedClass
extends SuperAnnotatedClass
implements ConfigurationBulkChangeHandler {
    private int nBulkSet = 0;
    private boolean complexConstructorInvoked = false;
    @ConfigurationParameter(name="parm1", category="cat1", isOptional=true)
    private volatile String parm = "";
    @ConfigurationParameter(category="cat2", isOptional=true)
    private volatile int parm2 = 0;
    @ConfigurationParameter(isFinal=true, isOptional=true)
    private volatile String finalString = "info";
    @ConfigurationParameter(isOptional=true)
    private volatile String annotatedString = "initialValue";
    @ConfigurationParameter(range="0..10", isOptional=true)
    private volatile double annotatedDouble = 3.14;
    @ConfigurationParameter(maxLength=4, isOptional=true)
    private volatile Map<String, Integer> annotatedMap = new ConcurrentHashMap<String, Integer>();
    @ConfigurationParameter(maxLength=5, isOptional=true)
    private volatile int[] annotatedIntArray = new int[]{1, 2, 3, 4};
    @ConfigurationParameter(maxLength=-1, isOptional=true)
    private volatile int[] annotatedUnboundIntArray = new int[]{1, 2, 3, 4};
    protected boolean setterParm1Called = false;

    public AnnotatedClass() {
        this.annotatedMap.put("elem1", 3);
        this.annotatedMap.put("elem2", 4);
        this.annotatedMap.put("elem3", 5);
    }

    public AnnotatedClass(String parm1, String annotatedString) {
        this();
        this.parm = parm1;
        this.annotatedString = annotatedString;
        this.complexConstructorInvoked = true;
    }

    public void setParameterBulk(Map<String, Object> parametersView) {
        this.nBulkSet = parametersView.size();
    }

    @ConfigurationParameterChanger(propertyName="parm1")
    public void fancySetParm1(String parm1) {
        this.parm = parm1;
        this.setterParm1Called = true;
    }

    @ConfigurationParameterChanger
    public void setParm2(int newVal) {
        if ((double)newVal < 0.0) {
            throw new IllegalArgumentException("Negative values for parm2 are not allowed.");
        }
        this.parm2 = newVal;
    }

    public String getParm() {
        return this.parm;
    }

    public int getParm2() {
        return this.parm2;
    }

    public String getFinalString() {
        return this.finalString;
    }

    public double getDouble() {
        return this.annotatedDouble;
    }

    public int[] getIntArray() {
        return this.annotatedIntArray;
    }

    public Map<String, Integer> getMap() {
        return this.annotatedMap;
    }

    public String getString() {
        return this.annotatedString;
    }

    public int getNumberOfBulkSetParameters() {
        return this.nBulkSet;
    }

    public boolean getComplexConstructorInvoked() {
        return this.complexConstructorInvoked;
    }
}

