package org.lsst.ccs.config;


import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.Set;

/**
 * Generic interface for writing, reading and finding properties files against 
 * a pattern.
 */
public abstract class WriterProvider {
    
    
    public synchronized static WriterProvider getInstance() {
        String className = null;
        //First check if System property org.lsst.ccs.config.WriterProvider has been set
        className = System.getProperty("org.lsst.ccs.config.WriterProvider", "");
        //If className is still not specified, then set it to:
        //  org.lsst.ccs.config.InMemoryFileWriterProvider if we are running tests
        //  org.lsst.ccs.config.FileWriterProvider if we are not running tests.
        if (className == null || className.isEmpty()) {
            className = System.getProperty("org.lsst.ccs.testcontext", "false").equals("true")
                    ? "org.lsst.ccs.config.InMemoryFileWriterProvider"
                    : "org.lsst.ccs.config.FileWriterProvider";
        }

        try {
            return (WriterProvider) Class.forName(className).newInstance();
        } catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Could not find class definition for WriterProvider " + className, cnfe);
        } catch (InstantiationException | IllegalAccessException ie) {
            throw new RuntimeException("Could not create instance of WriterProvider " + className, ie);
        }
    }
    
    
    public abstract PrintWriter getPrintWriter(String fileName) throws IOException;

    /**
     * @param fileName
     * @return null if no file matching filename has been found.
     * @throws IOException 
     */
    public abstract Properties getProperties(String fileName) throws IOException;
    
    abstract Set<String> findMatchingPropertiesFiles(String pattern);

    abstract String locateFile(String fileName);
}