package org.lsst.ccs.config;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/**
 * Handles a category of parameters.
 * @author LSST CCS Team
 */
public class CategoryHandler {
    
    private final String category;
    private final Set<ConfigurationParameterHandler> parameters = new HashSet<>();
    
    CategoryHandler(String category) {
        this.category = category;
    }
    
    void addParameterHandler(ConfigurationParameterHandler cph) {
        parameters.add(cph);
    }
    
    public String getCategory() {
        return category;
    } 
    
    public Collection<ConfigurationParameterHandler> getParameters() {
        return Collections.unmodifiableSet(parameters);
    }
}
