/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.config.LocalConfigurationDAO;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;

public class LocalConfigurationDAOTest
extends CcsTestCaseTemplate {
    private Set<String> categories = new HashSet<String>();

    @Before
    public void initTest() {
        this.categories.add("");
        this.categories.add("catA");
        this.categories.add("catB");
    }

    @Test
    public void testFindAvailableConfigurations() throws Exception {
        LocalConfigurationDAO proxy = new LocalConfigurationDAO("desc1", "desc11");
        Set res = proxy.findAvailableConfigurationsForCategory("aName", "catA");
        Assert.assertEquals((long)2L, (long)res.size());
        Assert.assertTrue((boolean)res.contains("configA1"));
        Assert.assertTrue((boolean)res.contains(""));
        res = proxy.findAvailableConfigurationsForCategory("aName", "catB");
        Assert.assertEquals((long)1L, (long)res.size());
        Assert.assertTrue((boolean)res.contains("configB2"));
        LocalConfigurationDAO proxy2 = new LocalConfigurationDAO("desc2", "desc21");
        res = proxy2.findAvailableConfigurationsForCategory("aName", "");
        Assert.assertEquals((long)3L, (long)res.size());
        Assert.assertTrue((boolean)res.contains("configD1"));
        Assert.assertTrue((boolean)res.contains("configD2"));
        Assert.assertTrue((boolean)res.contains(""));
    }

    @Test
    public void testLoadNamedConfiguration() throws Exception {
        LocalConfigurationDAO proxy = new LocalConfigurationDAO("desc1", "desc11");
        ConfigurationDescription configDesc = new ConfigurationDescription(this.categories).parseConfigurationString(new String[]{"catA:configA1", "catB:configB2", ":def1"});
        ConfigurationView cv1 = proxy.loadConfiguration("aName", configDesc);
        configDesc.setName("GLOBAL_NAME", -1);
        ConfigurationView cv2 = proxy.loadGlobalConfiguration("aName", "GLOBAL_NAME", -1);
        Assert.assertTrue((boolean)cv1.diff(cv2).isEmpty());
        Assert.assertTrue((boolean)cv2.diff(cv1).isEmpty());
    }
}

