package org.lsst.ccs.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.Set;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.utilities.logging.Logger;

/**
 * Reads and Writes properties files from/to a FileSystem, using 
 *
 * @author LSST CCS Team
 */
class FileWriterProvider extends WriterProvider {

    private static final Logger log = Logger.getLogger("org.lsst.ccs.config");
    
    @Override
    public PrintWriter getPrintWriter(String fileName) throws IOException {
        String tmpFileName = fileName;
        //Check if the properties file already exists in the Bootstrap Environment
        String pathInBootstrap = BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories(fileName);
        //If it does not exist...
        if (pathInBootstrap == null) {
            // then check if a there is a Bootstrap user defined directory in which to write it.
            String topMostUserDirectory = BootstrapResourceUtils.getTopUserResourceDirectory();
            //If there is not Bootstrap user Directory defined.....
            if (topMostUserDirectory == null) {
                throw new RuntimeException("There is no external resource directory in which to write the file. Please make sure to"
                        + " define one using environment variable CCS_RESOURCE_PATH.");
            } else {
                fileName = topMostUserDirectory + fileName;
            }
        } else {
            fileName = pathInBootstrap;
        }

        log.info("Saving " + tmpFileName + " to " + fileName);
 
        return new PrintWriter(fileName, "ISO-8859-1");
    }

    @Override
    public Properties getProperties(String fileName) throws IOException {
        Properties configProps = new Properties();
        InputStream propsIs = null;
        propsIs = BootstrapResourceUtils.getBootstrapResource(fileName);
        if (propsIs == null) { // The resource could not be found
            return null;
        }
        String path = BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories(fileName);
        log.info("Found configuration file : " + path);
        configProps.load(propsIs);
        return configProps;
    }

    @Override
    Set<String> findMatchingPropertiesFiles(String pattern) {
        return BootstrapResourceUtils.findMatchingResources(pattern);
    }

    @Override
    String locateFile(String fileName) {
        return BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories(fileName);
    }
}
