/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.config.AnnotatedClass;
import org.lsst.ccs.config.BulkSettingException;
import org.lsst.ccs.config.BulkValidationException;
import org.lsst.ccs.config.ConfigurationHandlerSet;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;

public class ConfigurationATest
extends CcsTestCaseTemplate {
    private static final String tag = "validationTest";
    private ConfigurationHandlerSet chs;

    @Before
    public void initAgents() throws Exception {
        this.chs = new ConfigurationHandlerSet();
        this.chs.addConfigurationHandlerForObject("someName", (Object)new AnnotatedClass());
        this.chs.initialize(tag);
    }

    @Test
    public void testStaticParameterModification() throws Exception {
        try {
            this.chs.setSingleParameter("someName", "finalString", (Object)"newValue");
            Assert.fail();
        }
        catch (BulkValidationException ex) {
            Throwable cause = ex.getCause();
            Assert.assertTrue((boolean)(cause instanceof IllegalStateException));
            Assert.assertTrue((boolean)cause.getMessage().contains("not modifiable at runtime"));
        }
    }

    @Test
    public void testConstraintRangeCheck() throws Exception {
        Throwable cause;
        try {
            this.chs.setSingleParameter("someName", "annotatedDouble", (Object)-1);
            Assert.fail();
        }
        catch (BulkValidationException ex) {
            cause = ex.getCause();
            Assert.assertTrue((String)cause.getClass().getSimpleName(), (boolean)(cause instanceof IllegalArgumentException));
            Assert.assertTrue((boolean)cause.getMessage().contains("range"));
        }
        try {
            this.chs.submitChange("someName", "annotatedDouble", (Object)-1);
            this.chs.submitChange("someName", "parm2", (Object)0);
            this.chs.commitBulkChange(null);
            Assert.fail();
        }
        catch (BulkValidationException ex) {
            cause = ex.getCause();
            Assert.assertTrue((boolean)(cause instanceof IllegalArgumentException));
            Assert.assertTrue((boolean)cause.getMessage().contains("range"));
        }
    }

    @Test
    public void testConfigChangerSetterFails() {
        try {
            this.chs.submitChange("someName", "annotatedDouble", (Object)0);
            this.chs.submitChange("someName", "parm2", (Object)-1);
            this.chs.commitBulkChange(null);
            Assert.fail();
        }
        catch (BulkSettingException bulkSettingException) {
            // empty catch block
        }
    }

    @Test
    public void testMapSetting() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("min", 20);
        map.put("max", 97);
        try {
            this.chs.setSingleParameter("someName", "annotatedMap", map);
            this.chs.setSingleParameter("someName", "minMax", (Object)"[min:13,max:41]");
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
    }
}

