/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.config.SuperAnnotatedClass;

public class AnnotatedClass
extends SuperAnnotatedClass {
    @ConfigurationParameter(name="parm1", category="cat1")
    private String parm = "";
    @ConfigurationParameter(category="cat2")
    private int parm2 = 0;
    @ConfigurationParameter(isFinal=true)
    private String finalString = "info";
    @ConfigurationParameter
    private String annotatedString = "initialValue";
    @ConfigurationParameter(range="0..10")
    private double annotatedDouble = 3.14;
    @ConfigurationParameter
    private Map<String, Integer> annotatedMap = new HashMap<String, Integer>();
    @ConfigurationParameter
    private int[] annotatedIntArray = new int[]{1, 2, 3, 4};
    protected boolean setterParm1Called = false;

    public AnnotatedClass() {
        this.annotatedMap.put("elem1", 3);
        this.annotatedMap.put("elem2", 4);
        this.annotatedMap.put("elem3", 5);
    }

    @ConfigurationParameterChanger(propertyName="parm1")
    public void fancySetParm1(String parm1) {
        this.parm = parm1;
        this.setterParm1Called = true;
    }

    @ConfigurationParameterChanger
    public void setParm2(int newVal) {
        if ((double)newVal < 0.0) {
            throw new IllegalArgumentException("no negative value");
        }
        this.parm2 = newVal;
    }

    public String getParm() {
        return this.parm;
    }

    public int getParm2() {
        return this.parm2;
    }

    public String getFinalString() {
        return this.finalString;
    }

    public double getDouble() {
        return this.annotatedDouble;
    }

    public int[] getIntArray() {
        return this.annotatedIntArray;
    }

    public Map<String, Integer> getMap() {
        return this.annotatedMap;
    }

    public String getString() {
        return this.annotatedString;
    }
}

