/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.config.remote;

import org.lsst.ccs.config.ConfigurationDAO;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.config.ConfigurationDescription;
import java.util.Set;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceManager;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;

/**
 * Implementation of the remote configuration proxy, through the CCS Buses.
 * It interacts with the server side configuration system through the CCS Buses
 * @author LSST CCS Team
 */
public class CCSBusesConfigurationDAO implements ConfigurationDAO {
    
    private final AgentPresenceManager apm;

    private final ConcurrentMessagingUtils cmu;
    
    private static final String DB_NAME = "localdb/configuration-server";
    
    public CCSBusesConfigurationDAO(AgentMessagingLayer aml) {
        cmu = new ConcurrentMessagingUtils(aml);
        
        apm = aml.getAgentPresenceManager();
    }
    
    @Override
    public ConfigurationDescription saveChangesForCategoriesAs(String agentName, ConfigurationDescription configDesc, ConfigurationInfo configInfo) throws ConfigurationServiceException {
        return registerConfiguration(agentName, configInfo);
    }

    @Override
    public ConfigurationView loadConfiguration(String agentName, ConfigurationDescription configDesc) throws ConfigurationServiceException {
        try {
            return (ConfigurationView) cmu.sendSynchronousCommand(new CommandRequest(DB_NAME, "loadConfiguration", agentName, configDesc));
        } catch (Exception ex) {
            throw new ConfigurationServiceException("remote configuration server unavailable", ex);
        }
    }
    
    @Override
    public ConfigurationView loadGlobalConfiguration(String agentName, String name, int version) {
        try {
            return (ConfigurationView) cmu.sendSynchronousCommand(new CommandRequest(DB_NAME, "loadGlobalConfiguration", agentName, name, version));
        } catch (Exception ex) {
            throw new ConfigurationServiceException("remote configuration server unavailable", ex);
        }
    }

    @Override
    public Set<String> findAvailableConfigurationsForCategory(String agentName, String category) {
        return null;
    }

    @Override
    public boolean isAvailable() {
        return apm.agentExists("localdb");
    }

    @Override
    public ConfigurationDescription registerConfiguration(String agentName, ConfigurationInfo configInfo) throws ConfigurationServiceException {
        try {
            return (ConfigurationDescription)cmu.sendSynchronousCommand(new CommandRequest(DB_NAME, "registerConfiguration", agentName, configInfo));
        } catch (Exception ex) {
            throw new ConfigurationServiceException("remote configuration server unavailable", ex);
        }
    }
}
