package org.lsst.ccs.config;


import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.Set;

/**
 * Generic interface for writing, reading and finding properties files against 
 * a pattern.
 */
public abstract class WriterProvider {
    
    private static WriterProvider instance = null;
    
    public synchronized static WriterProvider getInstance() {
        if (instance == null) {
            if ( System.getProperty("org.lsst.ccs.config.WriterProvier", "").equals("org.lsst.ccs.config.InMemoryWriterProvider") ) {
                instance = new InMemoryWriterProvider();   
            } else {
                instance = new FileWriterProvider();
            }
        }
        return instance;
    }
    
    public synchronized static void setInstance(WriterProvider wp) {
        instance = wp;
    }
    
    public abstract PrintWriter getPrintWriter(String fileName) throws IOException;

    /**
     * @param fileName
     * @return null if no file matching filename has been found.
     * @throws IOException 
     */
    public abstract Properties getProperties(String fileName) throws IOException;
    
    public abstract Set<String> findMatchingPropertiesFiles(String pattern);

    public abstract String locateFile(String fileName);
}