/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.config.ConfigurationWriterProvider;
import org.lsst.ccs.config.LocalConfigurationDAO;
import org.lsst.ccs.config.WriterProvider;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;

public class LocalConfigurationDAOTest
extends CcsTestCaseTemplate {
    private Map<String, ConfigurationWriterProvider> wps = new HashMap<String, ConfigurationWriterProvider>();
    private Set<String> categories = new HashSet<String>();

    @Before
    public void initTest() {
        this.categories.add("");
        this.categories.add("catA");
        this.categories.add("catB");
        this.wps.put("desc1", new ConfigurationWriterProvider("desc1"));
        this.wps.put("desc2", new ConfigurationWriterProvider("desc2"));
    }

    @After
    public void tearDown() {
        WriterProvider.setInstance(null);
    }

    @Test
    public void testSaveConfiguration() {
    }

    @Test
    public void testFindAvailableConfigurations() throws Exception {
        String[][] configNames;
        for (String[] config : configNames = new String[][]{{"desc1", "configA1", "catA"}, {"desc1", "", "catA"}, {"desc1", "configB2", "catB"}, {"desc2", "configD1", ""}, {"desc2", "configD2", ""}, {"desc2", "", ""}}) {
            PrintWriter printWriter = this.wps.get(config[0]).getConfigurationWriter(config[1], config[2]);
            printWriter.print("something");
            printWriter.flush();
            printWriter.close();
        }
        LocalConfigurationDAO proxy = new LocalConfigurationDAO("desc1");
        Set res = proxy.findAvailableConfigurationsForCategory("aName", "catA");
        Assert.assertEquals((long)2L, (long)res.size());
        Assert.assertTrue((boolean)res.contains("configA1"));
        Assert.assertTrue((boolean)res.contains(""));
        res = proxy.findAvailableConfigurationsForCategory("aName", "catB");
        Assert.assertEquals((long)1L, (long)res.size());
        Assert.assertTrue((boolean)res.contains("configB2"));
        LocalConfigurationDAO proxy2 = new LocalConfigurationDAO("desc2");
        res = proxy2.findAvailableConfigurationsForCategory("aName", "");
        Assert.assertEquals((long)3L, (long)res.size());
        Assert.assertTrue((boolean)res.contains("configD1"));
        Assert.assertTrue((boolean)res.contains("configD2"));
        Assert.assertTrue((boolean)res.contains(""));
    }

    @Test
    public void testLoadNamedConfiguration() throws Exception {
        String[][] configNames;
        for (String[] config : configNames = new String[][]{{"desc1", "configA1", "catA"}, {"desc1", "", "catA"}, {"desc1", "configB2", "catB"}, {"desc1", "def1", ""}}) {
            PrintWriter printWriter = this.wps.get(config[0]).getConfigurationWriter(config[1], config[2]);
            printWriter.print("comp/" + config[1] + "=" + config[2]);
            printWriter.flush();
            printWriter.close();
        }
        LocalConfigurationDAO proxy = new LocalConfigurationDAO("desc1");
        ConfigurationDescription configDesc = new ConfigurationDescription(this.categories).parseConfigurationString(new String[]{"catA:configA1", "catB:configB2", ":def1"});
        ConfigurationView cv1 = proxy.loadConfiguration("aName", configDesc);
        configDesc.setName("GLOBAL_NAME", -1);
        this.wps.get("desc1").setNamedConfiguration(configDesc);
        ConfigurationView cv2 = proxy.loadGlobalConfiguration("aName", "GLOBAL_NAME", -1);
        Assert.assertTrue((boolean)cv1.diff(cv2).isEmpty());
        Assert.assertTrue((boolean)cv2.diff(cv1).isEmpty());
    }
}

