package org.lsst.ccs.config;

import java.util.Date;

/**
 * Constants for this package.
 * @author bamade
 */

public class PackCst {

    private PackCst() {
        
    }
    
    /**
     * Based on insurance standard rules: this date represents an undetermined duration
     * (December 31 9999!). We just hope that databases will support this standard.
     * //TODO: replace with joda time :  ZeroIsMaxDateTimeField
     */
    @SuppressWarnings("deprecation")
    public static final long STILL_VALID = new Date(8099,11,31).getTime() ;

    /** Set to true in agent properties for agents that which to fully interact with the remote configuration service. */
    public static final String IS_CONFIG_REMOTE = "org.lsst.ccs.config.remote";
    
    /** Set to true in agent properties to advertise configuration persistence capabilities. */
    public static final String CONFIG_DB = "org.lsst.ccs.config.service";
}
