package org.lsst.ccs.config;

import java.util.Collections;
import java.util.Map;

/**
 * Step by step creation of a ConfigurationHandlerSet
 * @author LSST CCS Team
 */
public class ConfigurationHandlerSetBuilder {
    
    private final ConfigurationHandlerSet chs;
    
    public ConfigurationHandlerSetBuilder() {
        chs = new ConfigurationHandlerSet();
    }
    
    public ConfigurationHandlerSetBuilder addConfigurationHandlerForObject(String name, Object obj) {
        chs.addConfigurationHandlerForObject(name, obj);
        return this;
    }
    
    public ConfigurationProxy getConfigurationProxy() {
        return chs.getConfigurationProxy();
    }
    
    public ConfigurationHandlerSetBuilder initialize(String descriptionName) {
        return initialize(descriptionName, Collections.emptyMap());
    }

    /**
     * Initializes the configuration handler set object and returns it.
     * @param descriptionName
     * @param safeConfigFromTopNode potential safe configuration parameter values
     * @return the built ConfigurationHandlerSet
     */
    public ConfigurationHandlerSetBuilder initialize(String descriptionName, Map safeConfigFromTopNode) {
        if (!chs.isEmpty()) {
            // load the safe configuration
            chs.initialize(descriptionName, safeConfigFromTopNode);
            // Sets the remote configuration proxy if necessary
            chs.setRemoteConfigurationProxy();
        }
        return this;
    }
    
    public ConfigurationHandlerSet get() {
        if (chs.isEmpty()) return null;
        return chs;
    }
    
}
