/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.config.ComponentWithCategories;
import org.lsst.ccs.config.ConfigUtils;
import org.lsst.ccs.config.ConfigurationHandlerSet;
import org.lsst.ccs.config.ConfigurationHandlerSetBuilder;
import org.lsst.ccs.config.ConfigurationWriterProvider;
import org.lsst.ccs.config.WriterProvider;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;

public class ConfigurationLoadingWithCategoriesTest
extends CcsTestCaseTemplate {
    private ConfigurationWriterProvider writerProvider;
    private ConfigurationHandlerSet chs;
    private ComponentWithCategories main;
    private ComponentWithCategories son;
    private final String tagName = "withCategories";
    private Set<String> categories;

    @Before
    public void init() throws Exception {
        this.writerProvider = new ConfigurationWriterProvider();
        this.main = new ComponentWithCategories();
        this.son = new ComponentWithCategories();
        this.chs = new ConfigurationHandlerSetBuilder().addConfigurationHandlerForObject("son", (Object)this.son).addConfigurationHandlerForObject("main", (Object)this.main).initialize("withCategories").get();
        this.categories = this.chs.getCategorySet();
        this.chs.loadCategories(ConfigUtils.parseConfigurationStringWithDefaults(this.categories, (String[])new String[0]));
    }

    @After
    public void tearDown() {
        WriterProvider.setInstance(null);
    }

    @Test
    public void testConfigurationOperationSequence() throws Exception {
        this.chs.setSingleParameter("main", "confValD", (Object)"0");
        this.chs.setSingleParameter("main", "confValA", (Object)"1");
        this.chs.setSingleParameter("main", "confValB", (Object)"2");
        this.chs.saveChangesForCategories(this.chs.getTaggedCategoriesForCats(this.chs.getCategorySet()));
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2}, (int[])this.main.getConfValues());
        Properties props = this.writerProvider.getConfigurationProperties("withCategories", "", "");
        Assert.assertEquals((String)"confValD", (Object)"0", (Object)props.get("main/confValD"));
        props = this.writerProvider.getConfigurationProperties("withCategories", "", "catA");
        Assert.assertEquals((String)"confValA : ", (Object)"1", (Object)props.getProperty("main/confValA"));
        props = this.writerProvider.getConfigurationProperties("withCategories", "", "catB");
        Assert.assertEquals((String)"confValB : ", (Object)"2", (Object)props.getProperty("main/confValB"));
        this.chs.setSingleParameter("main", "confValD", (Object)"3");
        this.chs.saveChangesForCategories(ConfigUtils.parseConfigurationString(this.categories, (String[])new String[]{"D3", "catA:A1", "catB:B2"}));
        props = this.writerProvider.getConfigurationProperties("withCategories", "D3", "");
        Assert.assertEquals((String)"confValD : ", (Object)"3", (Object)props.getProperty("main/confValD"));
        props = this.writerProvider.getConfigurationProperties("withCategories", "A1", "catA");
        Assert.assertEquals((String)"confValA : ", (Object)"1", (Object)props.getProperty("main/confValA"));
        props = this.writerProvider.getConfigurationProperties("withCategories", "B2", "catB");
        Assert.assertEquals((String)"confValB : ", (Object)"2", (Object)props.getProperty("main/confValB"));
        Assert.assertArrayEquals((int[])new int[]{3, 1, 2}, (int[])this.main.getConfValues());
        this.chs.setSingleParameter("main", "confValB", (Object)"0");
        this.chs.saveChangesForCategories(ConfigUtils.parseConfigurationString(this.categories, (String[])new String[]{"catB:B0"}));
        props = this.writerProvider.getConfigurationProperties("withCategories", "B0", "catB");
        Assert.assertEquals((String)"confValB : ", (Object)"0", (Object)props.getProperty("main/confValB"));
        Assert.assertArrayEquals((int[])new int[]{3, 1, 0}, (int[])this.main.getConfValues());
        this.chs.setSingleParameter("main", "confValD", (Object)"7");
        this.chs.saveChangesForCategories(this.chs.getTaggedCategoriesForCats(this.categories));
        props = this.writerProvider.getConfigurationProperties("withCategories", "D3", "");
        Assert.assertEquals((String)"confValD : ", (Object)"7", (Object)props.getProperty("main/confValD"));
        Assert.assertArrayEquals((int[])new int[]{7, 1, 0}, (int[])this.main.getConfValues());
        this.chs.setSingleParameter("main", "confValD", (Object)"0");
        this.chs.setSingleParameter("main", "confValA", (Object)"4");
        this.chs.setSingleParameter("main", "confValB", (Object)"2");
        this.chs.saveChangesForCategories(ConfigUtils.parseConfigurationString(this.categories, (String[])new String[]{"D0", "catA:A4", "catB:B2"}));
        props = this.writerProvider.getConfigurationProperties("withCategories", "D0", "");
        Assert.assertEquals((String)"confValD : ", (Object)"0", (Object)props.getProperty("main/confValD"));
        props = this.writerProvider.getConfigurationProperties("withCategories", "A4", "catA");
        Assert.assertEquals((String)"confValA : ", (Object)"4", (Object)props.getProperty("main/confValA"));
        props = this.writerProvider.getConfigurationProperties("withCategories", "B2", "catB");
        Assert.assertEquals((String)"confValB : ", (Object)"2", (Object)props.getProperty("main/confValB"));
        Assert.assertArrayEquals((int[])new int[]{0, 4, 2}, (int[])this.main.getConfValues());
        this.chs.loadCategories(ConfigUtils.parseConfigurationStringWithDefaults(this.categories, (String[])new String[]{"D3", "catA:A1", "catB:B0"}));
        Assert.assertArrayEquals((int[])new int[]{7, 1, 0}, (int[])this.main.getConfValues());
        this.chs.loadCategories(ConfigUtils.parseConfigurationStringWithDefaults(this.categories, (String[])new String[0]));
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2}, (int[])this.main.getConfValues());
        Assert.assertEquals((long)3L, (long)this.categories.size());
        Assert.assertTrue((boolean)this.categories.contains(""));
        Assert.assertTrue((boolean)this.categories.contains("catA"));
        Assert.assertTrue((boolean)this.categories.contains("catB"));
    }

    @Test
    public void testLoadCategories() throws Exception {
        this.chs.setSingleParameter("main", "confValD", (Object)10);
        this.chs.setSingleParameter("main", "confValA", (Object)9);
        this.chs.setSingleParameter("main", "confValB", (Object)8);
        this.chs.saveChangesForCategories(ConfigUtils.parseConfigurationString(this.categories, (String[])new String[]{":D1", "catA:confA1", "catB:confB1"}));
        Assert.assertArrayEquals((int[])new int[]{10, 9, 8}, (int[])this.main.getConfValues());
        this.chs.setSingleParameter("main", "confValA", (Object)7);
        this.chs.saveChangesForCategories(ConfigUtils.parseConfigurationString(this.categories, (String[])new String[]{"catA:confA2"}));
        Assert.assertArrayEquals((int[])new int[]{10, 7, 8}, (int[])this.main.getConfValues());
        this.chs.loadCategories(ConfigUtils.parseConfigurationString(this.categories, (String[])new String[]{"catA:confA1"}));
        Assert.assertArrayEquals((int[])new int[]{10, 9, 8}, (int[])this.main.getConfValues());
    }

    @Test
    public void testSaveCategories() throws Exception {
        this.chs.setSingleParameter("main", "confValD", (Object)10);
        this.chs.setSingleParameter("main", "confValA", (Object)9);
        this.chs.setSingleParameter("main", "confValB", (Object)8);
        this.chs.saveChangesForCategories(ConfigUtils.parseConfigurationString(this.categories, (String[])new String[]{"confD1", "catB:confB1"}));
        Properties props = this.writerProvider.getConfigurationProperties("withCategories", "confD1", "");
        Assert.assertEquals((String)"confValD : ", (Object)"10", (Object)props.getProperty("main/confValD"));
        props = this.writerProvider.getConfigurationProperties("withCategories", "confB1", "catB");
        Assert.assertEquals((String)"confValB : ", (Object)"8", (Object)props.getProperty("main/confValB"));
        Assert.assertArrayEquals((int[])new int[]{10, 9, 8}, (int[])this.main.getConfValues());
        this.chs.setSingleParameter("main", "confValD", (Object)9);
        this.chs.setSingleParameter("main", "confValB", (Object)7);
        Assert.assertArrayEquals((int[])new int[]{9, 9, 7}, (int[])this.main.getConfValues());
        this.chs.saveChangesForCategories(this.chs.getTaggedCategoriesForCats(ConfigUtils.parseCategories(this.categories, (String[])new String[]{"", "catB"})));
        props = this.writerProvider.getConfigurationProperties("withCategories", "confD1", "");
        Assert.assertEquals((String)"confValD : ", (Object)"9", (Object)props.getProperty("main/confValD"));
        props = this.writerProvider.getConfigurationProperties("withCategories", "confB1", "catB");
        Assert.assertEquals((String)"confValB : ", (Object)"7", (Object)props.getProperty("main/confValB"));
        this.chs.saveChangesForCategories(ConfigUtils.parseConfigurationString(this.categories, (String[])new String[]{"catA:confA1"}));
        props = this.writerProvider.getConfigurationProperties("withCategories", "confA1", "catA");
        Assert.assertEquals((String)"confValA : ", (Object)"9", (Object)props.getProperty("main/confValA"));
        Set configForCat = this.chs.findAvailableConfigurationsForCategory("");
        Assert.assertEquals((long)1L, (long)configForCat.size());
        Assert.assertTrue((boolean)configForCat.contains("confD1"));
        configForCat = this.chs.findAvailableConfigurationsForCategory("catB");
        Assert.assertEquals((long)1L, (long)configForCat.size());
        Assert.assertTrue((boolean)configForCat.contains("confB1"));
        configForCat = this.chs.findAvailableConfigurationsForCategory("catA");
        Assert.assertEquals((long)1L, (long)configForCat.size());
        Assert.assertTrue((boolean)configForCat.contains("confA1"));
    }

    @Test
    public void testDropCategories() throws Exception {
        int[] defaultValues = this.main.getConfValues();
        this.chs.setSingleParameter("main", "confValD", (Object)10);
        this.chs.setSingleParameter("main", "confValA", (Object)9);
        this.chs.setSingleParameter("main", "confValB", (Object)8);
        this.chs.saveChangesForCategories(ConfigUtils.parseConfigurationString(this.categories, (String[])new String[]{"confD1", "catB:confB1"}));
        Assert.assertArrayEquals((int[])new int[]{10, 9, 8}, (int[])this.main.getConfValues());
        this.chs.dropChangesForCategories(this.categories);
        Assert.assertArrayEquals((int[])new int[]{10, defaultValues[1], 8}, (int[])this.main.getConfValues());
    }

    @Test
    public void testResetConfiguration() throws Exception {
        int[] initialValues = this.main.getConfValues();
        this.chs.setSingleParameter("main", "confValD", (Object)10);
        this.chs.setSingleParameter("main", "confValA", (Object)9);
        this.chs.setSingleParameter("main", "confValB", (Object)8);
        this.chs.dropChangesForCategories(ConfigUtils.parseCategories(this.categories, (String[])new String[]{"catA", "catB"}));
        this.chs.saveChangesForCategories(this.chs.getTaggedCategoriesForCats(this.categories));
        Assert.assertArrayEquals((String)("main module config values : " + Arrays.toString(this.main.getConfValues())), (int[])new int[]{10, initialValues[1], initialValues[2]}, (int[])this.main.getConfValues());
    }
}

