/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.PrintWriter;
import java.util.Properties;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.config.AnnotatedClass;
import org.lsst.ccs.config.ConfigUtils;
import org.lsst.ccs.config.ConfigurationHandlerSet;
import org.lsst.ccs.config.ConfigurationHandlerSetBuilder;
import org.lsst.ccs.config.ConfigurationWriterProvider;
import org.lsst.ccs.config.WriterProvider;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;

public class ConfigurationLoadAndSaveTest
extends CcsTestCaseTemplate {
    private ConfigurationWriterProvider writer;
    private ConfigurationHandlerSet chs;
    private AnnotatedClass obj;
    private final String tagName = "withCategories";

    @Before
    public void init() {
        this.writer = new ConfigurationWriterProvider();
    }

    @After
    public void tearDown() {
        WriterProvider.setInstance(null);
    }

    @Test
    public void testSafeConfiguration() throws Exception {
        PrintWriter pw = this.writer.getConfigurationWriter("withCategories", "safe", "cat2");
        pw.println("someName//parm2=10");
        pw.flush();
        pw.close();
        pw = this.writer.getConfigurationWriter("withCategories", "safe", "");
        pw.println("someName//finalString=safe");
        pw.flush();
        pw.close();
        this.obj = new AnnotatedClass();
        this.chs = new ConfigurationHandlerSetBuilder().addConfigurationHandlerForObject("someName", (Object)this.obj).initialize("withCategories").get();
        Assert.assertEquals((float)this.obj.getParm2(), (float)10.0f, (float)this.obj.getParm2());
        Assert.assertEquals((String)this.obj.getFinalString(), (Object)"safe", (Object)this.obj.getFinalString());
        this.chs.loadCategories(ConfigUtils.parseConfigurationStringWithDefaults((Set)this.chs.getCategorySet(), (String[])new String[0]));
        Assert.assertEquals((String)"the initial value for parm2 should be the one dictated by the safe configuration file", (long)10L, (long)this.obj.getParm2());
    }

    @Test
    public void testSafeConfigurationFails() throws Exception {
        PrintWriter pw = this.writer.getConfigurationWriter("withCategories", "safe", "");
        pw.println("someName//aDbl=11");
        pw.flush();
        pw.close();
        this.obj = new AnnotatedClass();
        try {
            this.chs = new ConfigurationHandlerSetBuilder().addConfigurationHandlerForObject("someName", (Object)this.obj).initialize("withCategories").get();
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (RuntimeException ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)ex.getMessage().contains("could not load safe configuration"));
        }
    }

    @Test
    public void testStartupConfiguration() throws Exception {
        this.obj = new AnnotatedClass();
        this.chs = new ConfigurationHandlerSetBuilder().addConfigurationHandlerForObject("someName", (Object)this.obj).initialize("withCategories").get();
        this.chs.saveChangesForCategories(ConfigUtils.parseConfigurationString((Set)this.chs.getCategorySet(), (String[])new String[]{"conf"}));
        Properties props = this.writer.getConfigurationProperties("withCategories", "conf", "");
        Assert.assertEquals((String)"properties file size", (long)2L, (long)props.size());
        PrintWriter pw = this.writer.getConfigurationWriter("withCategories", "safe", "");
        pw.println("someName//finalString=safe");
        pw.println("someName//aDbl=3.14");
        pw.flush();
        pw.close();
        this.obj = new AnnotatedClass();
        this.chs = new ConfigurationHandlerSetBuilder().addConfigurationHandlerForObject("someName", (Object)this.obj).initialize("withCategories").get();
        Assert.assertEquals((Object)"safe", (Object)this.obj.getFinalString());
        Assert.assertEquals((String)"aDbl", (double)3.14, (double)this.obj.getDouble(), (double)0.1);
        this.chs.loadCategories(ConfigUtils.parseConfigurationString((Set)this.chs.getCategorySet(), (String[])new String[]{"conf"}));
        Assert.assertEquals((String)"aDbl", (double)1.0, (double)this.obj.getDouble(), (double)0.1);
    }
}

