package org.lsst.ccs.config;

/**
 * Step by step creation of a ConfigurationHandlerSet
 * @author LSST CCS Team
 */
public class ConfigurationHandlerSetBuilder {
    
    private final ConfigurationHandlerSet chs;
    
    public ConfigurationHandlerSetBuilder() {
        chs = new ConfigurationHandlerSet();
    }
    
    public ConfigurationHandlerSetBuilder addConfigurationHandlerForObject(String name, Object obj) {
        chs.addConfigurationHandlerForObject(name, obj);
        return this;
    }
    
    public ConfigurationProxy getConfigurationProxy() {
        return chs.getConfigurationProxy();
    }
    
    /**
     * Initializes the configuration handler set object and returns it.
     * @param descriptionName
     * @return the built ConfigurationHandlerSet
     */
    public ConfigurationHandlerSetBuilder initialize(String descriptionName) {
        if (!chs.isEmpty()) {
            // load the safe configuration
            chs.initialize(descriptionName);
            // Sets the remote configuration proxy if necessary
            chs.setRemoteConfigurationProxy();
        }
        return this;
    }
    
    public ConfigurationHandlerSet get() {
        if (chs.isEmpty()) return null;
        return chs;
    }
    
}
