/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.config.ConfigurationProxy;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.config.FileWriterProvider;
import org.lsst.ccs.config.InMemoryWriterProvider;
import org.lsst.ccs.config.WriterProvider;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.structs.ParameterPath;

class LocalConfigurationProxy
implements ConfigurationProxy {
    public static final Comparator<ConfigurationParameterInfo> configurationParameterComparator = new Comparator<ConfigurationParameterInfo>(){

        @Override
        public int compare(ConfigurationParameterInfo o1, ConfigurationParameterInfo o2) {
            String componentName = o1.getComponentName();
            String otherComponentName = o2.getComponentName();
            if (componentName.equals("main") && !otherComponentName.equals("main")) {
                return 1;
            }
            if (otherComponentName.equals("main") && !otherComponentName.equals("main/")) {
                return -1;
            }
            if (componentName.equals(otherComponentName)) {
                return o1.getParameterName().compareTo(o2.getParameterName());
            }
            return componentName.compareTo(otherComponentName);
        }
    };
    static WriterProvider writerProvider;
    private static final Logger log;
    private final String descriptionName;
    Logger logger = Logger.getLogger((String)"org.lsst.ccs.config");
    private static final String[][] TABLE;

    protected static WriterProvider getWriterProvider() {
        if (writerProvider == null) {
            writerProvider = System.getProperty("org.lsst.ccs.config.WriterProvier", "").equals("org.lsst.ccs.config.InMemoryWriterProvider") ? new InMemoryWriterProvider() : new FileWriterProvider();
        }
        return writerProvider;
    }

    protected static void setWriterProvider(WriterProvider wp) {
        writerProvider = wp;
    }

    LocalConfigurationProxy(String descriptionName) {
        this.descriptionName = descriptionName;
        writerProvider = LocalConfigurationProxy.getWriterProvider();
    }

    @Override
    public synchronized void saveChangesForCategoriesAs(Map<String, String> taggedCategories, List<ConfigurationParameterInfo> values) throws ConfigurationServiceException {
        Map valuesPerCategory = ConfigurationInfo.getParameterInfoGroupByCategory(values);
        for (Map.Entry<String, String> entry : taggedCategories.entrySet()) {
            PrintWriter writer;
            try {
                writer = writerProvider.getPrintWriter(entry.getValue(), this.descriptionName, entry.getKey());
            }
            catch (IOException ex) {
                throw new ConfigurationServiceException("could not open file", ex);
            }
            TreeSet<ConfigurationParameterInfo> modifiedParameters = new TreeSet<ConfigurationParameterInfo>(configurationParameterComparator);
            for (ConfigurationParameterInfo cpi : (List)valuesPerCategory.get(entry.getKey())) {
                if (cpi.isFinal()) continue;
                modifiedParameters.add(cpi);
            }
            for (ConfigurationParameterInfo parameter : modifiedParameters) {
                writer.println(LocalConfigurationProxy.toPropertyString(parameter, false));
            }
            writer.flush();
            writer.close();
        }
    }

    public static String toPropertyString(ConfigurationParameterInfo parmInfo, boolean commentOutValue) {
        String propName;
        String currentValue = parmInfo.getCurrentValue();
        if (currentValue == null) {
            currentValue = "";
        }
        StringBuilder builder = new StringBuilder();
        String pathName = parmInfo.getPathName();
        builder.append("#********  ").append(pathName);
        String description = parmInfo.getDescription();
        if (description != null) {
            String withPounds = description.replaceAll("\n", "\n#");
            builder.append('\n').append("#** ").append(withPounds);
        }
        builder.append("\n#** type : ").append(LocalConfigurationProxy.getTypeInfo(parmInfo.getType()));
        if (parmInfo.getCategoryName() != null && !"".equals(parmInfo.getCategoryName().trim())) {
            builder.append("\n#** category : ").append(parmInfo.getCategoryName());
        }
        propName = (propName = new ParameterPath(parmInfo.getComponentName(), parmInfo.getParameterName()).toString()) == null || "".equals(propName.trim()) ? pathName : propName.trim().replaceAll(" ", "\\\\ ");
        builder.append("\n#********\n").append(commentOutValue ? "#" : "").append(propName).append(" = ").append(currentValue).append('\n');
        return builder.toString();
    }

    private static String getTypeInfo(String typeName) {
        String res = typeName;
        for (String[] keyVal : TABLE) {
            if (!keyVal[0].equals(typeName)) continue;
            return keyVal[1];
        }
        return res;
    }

    @Override
    public Map<String, Properties> loadCategories(Map<String, String> taggedCategories) throws ConfigurationServiceException {
        if (taggedCategories.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Properties> res = new HashMap<String, Properties>();
        for (Map.Entry<String, String> entry : taggedCategories.entrySet()) {
            String cat = entry.getKey();
            String tag = entry.getValue();
            try {
                Properties configProps = writerProvider.getConfigurationProperties(tag, this.descriptionName, cat);
                if (configProps == null) {
                    if (tag.equals("") || tag.equals("safe")) continue;
                    throw new IllegalArgumentException("could not find configuration file " + tag + " for category " + cat);
                }
                for (Map.Entry<Object, Object> prop : configProps.entrySet()) {
                    String name = (String)prop.getKey();
                    String val = (String)prop.getValue();
                    ParameterPath pp = ParameterPath.valueOf((String)name);
                    Properties props = (Properties)res.get(pp.getComponentName());
                    if (props == null) {
                        props = new Properties();
                        res.put(pp.getComponentName(), props);
                    }
                    props.setProperty(pp.getParameterName(), val);
                }
            }
            catch (IOException ex) {
                throw new ConfigurationServiceException(ex.getMessage(), ex);
            }
        }
        return res;
    }

    @Override
    public Set<String> findAvailableConfigurationsForCategory(String category) {
        return writerProvider.findAvailableConfigurationsForCategory(this.descriptionName, category);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    static {
        log = Logger.getLogger((String)"org.lsst.ccs.config");
        TABLE = new String[][]{{"java.lang.Integer", "integer (example : 6)"}, {"java.lang.String", "String"}, {"java.lang.Double", "double (example : 3.0)"}, {"java.lang.Float", "float (example : 3.0)"}, {"java.lang.Boolean", "boolean (example : true)"}, {"[I", "array of integers (example : [1,34,666] )"}, {"[D", "array of doubles (example : [1.0,34.0,666.66] )"}, {"[F", "array of floats (example : [1.0,34.0,666.66] )"}, {"[Ljava.lang.String;", "array of Strings (example : ['hello', 'world'] )"}};
    }
}

