/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.PrintWriter;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.config.InMemoryWriterProvider;
import org.lsst.ccs.config.LocalConfigurationProxy;
import org.lsst.ccs.config.WriterProvider;

public class LocalConfigurationProxyTest {
    private static final String[] cats = new String[]{"", "catA", "catB"};
    private WriterProvider writerProvider;

    @Before
    public void initTest() {
        this.writerProvider = new InMemoryWriterProvider();
        LocalConfigurationProxy.setWriterProvider((WriterProvider)this.writerProvider);
    }

    @After
    public void tearDown() {
        LocalConfigurationProxy.setWriterProvider(null);
    }

    @Test
    public void testFindAvailableConfigurations() throws Exception {
        String[][] configNames;
        for (String[] config : configNames = new String[][]{{"desc1", "configA1", "catA"}, {"desc1", "", "catA"}, {"desc1", "configB2", "catB"}, {"desc2", "configD1", ""}, {"desc2", "configD2", ""}, {"desc2", "", ""}}) {
            PrintWriter printWriter = this.writerProvider.getPrintWriter(config[1], config[0], config[2]);
            printWriter.print("something");
            printWriter.flush();
            printWriter.close();
        }
        Set res = this.writerProvider.findAvailableConfigurationsForCategory("desc1", "catA");
        Assert.assertEquals((long)2L, (long)res.size());
        Assert.assertTrue((boolean)res.contains("configA1"));
        Assert.assertTrue((boolean)res.contains(""));
        res = this.writerProvider.findAvailableConfigurationsForCategory("desc1", "catB");
        Assert.assertEquals((long)1L, (long)res.size());
        Assert.assertTrue((boolean)res.contains("configB2"));
        res = this.writerProvider.findAvailableConfigurationsForCategory("desc2", "");
        Assert.assertEquals((long)3L, (long)res.size());
        Assert.assertTrue((boolean)res.contains("configD1"));
        Assert.assertTrue((boolean)res.contains("configD2"));
        Assert.assertTrue((boolean)res.contains(""));
    }

    @Test
    public void testSaveAndLoadConfiguration() {
    }
}

