/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.config.BulkChangeComponent;
import org.lsst.ccs.config.BulkSettingException;
import org.lsst.ccs.config.BulkValidationException;
import org.lsst.ccs.config.ConfigUtils;
import org.lsst.ccs.config.ConfigurationHandlerSet;
import org.lsst.ccs.config.ConfigurationHandlerSetBuilder;
import org.lsst.ccs.config.LocalConfigurationProxy;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;

public class ConfigurationBulkChangesTest
extends CcsTestCaseTemplate {
    private static Map<String, BulkChangeComponent> comps = new LinkedHashMap<String, BulkChangeComponent>();
    private static final String tag = "withBulkSetting";
    private ConfigurationHandlerSet chs;
    private final Object[] changesOK = new Object[]{"OK", 3, 8, 6.28};
    private final Object[] changesValNOK = new Object[]{"NOK", 8, 6, 6.28};
    private final Object[] changesSettingMaxNOK = new Object[]{"NOK", 8, 101, 6.28};
    private final Object[] changesSettingMinNOK = new Object[]{"NOK", -10, 60, 6.28};
    private Object[] initVals;

    @Before
    public void initAgents() throws Exception {
        comps.put("main", new BulkChangeComponent());
        comps.put("son1", new BulkChangeComponent());
        comps.put("son2", new BulkChangeComponent());
        ConfigurationHandlerSetBuilder chsb = new ConfigurationHandlerSetBuilder();
        for (Map.Entry<String, BulkChangeComponent> entry : comps.entrySet()) {
            chsb.addConfigurationHandlerForObject(entry.getKey(), (Object)entry.getValue());
        }
        this.chs = chsb.initialize(tag).get();
        this.chs.loadCategories(ConfigUtils.parseConfigurationStringWithDefaults((Set)this.chs.getCategorySet(), (String[])new String[0]));
        this.initVals = comps.get("main").getConfValues();
    }

    @After
    public void shutdownAgents() throws Exception {
        LocalConfigurationProxy.setWriterProvider(null);
    }

    @Test
    public void testCommitBulkChangesFailsAtValidation() throws Exception {
        this.submitChanges("main", this.changesOK);
        this.submitChanges("son1", this.changesValNOK);
        this.submitChanges("son2", this.changesOK);
        try {
            this.chs.commitBulkChange(Collections.EMPTY_MAP);
            Assert.fail();
        }
        catch (BulkValidationException ex) {
            for (String key : comps.keySet()) {
                Assert.assertEquals((String)("submitted changes should not have been dropped for " + key), (long)4L, (long)this.chs.getSubmittedChangesForComponent(key).size());
            }
            Assert.assertTrue((String)ex.getCause().getMessage(), (boolean)ex.getCause().getMessage().contains("min greater than max"));
        }
        for (String key : comps.keySet()) {
            Assert.assertArrayEquals((String)("values should not have changed for " + key), (Object[])this.initVals, (Object[])comps.get(key).getConfValues());
        }
        Assert.assertEquals((Object)ConfigurationState.CONFIGURED, (Object)this.chs.getConfigurationInfo().getConfigurationState());
    }

    @Test
    public void testCommitBulkChangesSucceeds() throws Exception {
        this.submitChanges("son1", this.changesOK);
        this.submitChanges("son2", this.changesOK);
        this.submitChanges("main", this.changesOK);
        this.chs.commitBulkChange(Collections.EMPTY_MAP);
        ConfigurationInfo ci = this.chs.getConfigurationInfo();
        Assert.assertArrayEquals((String)"changes should have been applied", (Object[])this.changesOK, (Object[])comps.get("main").getConfValues());
        Assert.assertArrayEquals((String)"changes should have been applied", (Object[])this.changesOK, (Object[])comps.get("son1").getConfValues());
        Assert.assertArrayEquals((String)"changes should have been applied", (Object[])this.changesOK, (Object[])comps.get("son2").getConfValues());
        Assert.assertEquals((Object)ConfigurationState.DIRTY, (Object)ci.getConfigurationState());
        Assert.assertEquals((long)0L, (long)this.chs.getSubmittedChangesForComponent("main").size());
    }

    @Test
    public void testSetSingleParameter() throws Exception {
        this.chs.submitChange("main", "min", (Object)11);
        this.chs.setSingleParameter("main", "max", (Object)13);
        Assert.assertEquals((long)1L, (long)this.chs.getSubmittedChangesForComponent("main").size());
    }

    @Test
    public void testCommitBulkChangesFailsAtBulkSetting() throws Exception {
        this.submitChanges("main", this.changesOK);
        this.submitChanges("son1", this.changesSettingMaxNOK);
        this.submitChanges("son2", this.changesOK);
        try {
            this.chs.commitBulkChange(Collections.EMPTY_MAP);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (BulkSettingException ex) {
            Throwable cause = ex.getCause();
            Assert.assertTrue((boolean)(cause instanceof IllegalArgumentException));
            for (String name : comps.keySet()) {
                Assert.assertEquals((String)"all changes should have been dropped", (long)0L, (long)this.chs.getSubmittedChangesForComponent(name).size());
            }
        }
        ConfigurationInfo ci = this.chs.getConfigurationInfo();
        Assert.assertArrayEquals((String)"should have been set", (Object[])this.changesOK, (Object[])comps.get("main").getConfValues());
        Assert.assertArrayEquals((String)"nothing should have been changed", (Object[])this.initVals, (Object[])comps.get("son1").getConfValues());
        Assert.assertArrayEquals((String)"nothing should have been changed", (Object[])this.initVals, (Object[])comps.get("son2").getConfValues());
        Assert.assertEquals((Object)ConfigurationState.DIRTY, (Object)ci.getConfigurationState());
    }

    @Test
    public void testCommitBulkChangesFailsHalfwayAtBulkSetting() throws Exception {
        this.submitChanges("son1", this.changesSettingMinNOK);
        try {
            this.chs.commitBulkChange(Collections.EMPTY_MAP);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (BulkSettingException ex) {
            Throwable cause = ex.getCause();
            Assert.assertTrue((boolean)(cause instanceof IllegalArgumentException));
            Assert.assertTrue((String)cause.getMessage(), (boolean)cause.getMessage().contains("min cannot be negative"));
            Assert.assertEquals((long)0L, (long)this.chs.getSubmittedChangesForComponent("main").size());
        }
        ConfigurationInfo ci = this.chs.getConfigurationInfo();
        BulkChangeComponent son1 = comps.get("son1");
        Assert.assertEquals((long)0L, (long)son1.getMin());
        Assert.assertEquals((long)60L, (long)son1.getMax());
        Assert.assertEquals((double)3.14, (double)son1.getValue(), (double)0.0);
        Assert.assertEquals((Object)ConfigurationState.DIRTY, (Object)ci.getConfigurationState());
        List delta = ci.getLatestChanges();
        Assert.assertEquals((String)"only one parameter should have been effectively changed", (long)1L, (long)delta.size());
        ConfigurationParameterInfo cpi = (ConfigurationParameterInfo)delta.get(0);
        Assert.assertEquals((String)"main/max should be part of the delta", (Object)"son1/max", (Object)cpi.getPathName());
        Assert.assertEquals((String)"main/max value should be 60", (Object)"60", (Object)cpi.getCurrentValue());
    }

    @Test
    public void testSpuriousChangeAtValidationStep() throws Exception {
        this.submitChanges("main", this.changesOK);
        this.submitChanges("son1", this.changesOK);
        this.submitChanges("son2", this.changesOK);
        BulkChangeComponent son1 = comps.get("son1");
        son1.setSpuriousValidation(true);
        try {
            this.chs.commitBulkChange(Collections.EMPTY_MAP);
            Assert.fail();
        }
        catch (BulkSettingException ex) {
            for (String key : comps.keySet()) {
                Assert.assertEquals((String)("submitted changes should have been dropped " + key), (long)0L, (long)this.chs.getSubmittedChangesForComponent(key).size());
            }
            Assert.assertTrue((String)ex.getMessage(), (boolean)ex.getMessage().contains("son1/value"));
        }
        ConfigurationInfo ci = this.chs.getConfigurationInfo();
        Assert.assertArrayEquals((String)"values should not have changed for main", (Object[])this.initVals, (Object[])comps.get("main").getConfValues());
        Assert.assertArrayEquals((String)"1 value should have changed for son1", (Object[])new Object[]{null, 0, 10, 6.28}, (Object[])comps.get("son1").getConfValues());
        Assert.assertArrayEquals((String)"values should not have changed for son2", (Object[])this.initVals, (Object[])comps.get("son2").getConfValues());
        Assert.assertEquals((Object)ConfigurationState.DIRTY, (Object)this.chs.getConfigurationInfo().getConfigurationState());
    }

    @Test
    public void testSpuriousChangeAtSettingStep() throws Exception {
        this.submitChanges("main", this.changesOK);
        this.submitChanges("son1", this.changesOK);
        this.submitChanges("son2", this.changesOK);
        BulkChangeComponent son1 = comps.get("son1");
        son1.setSpuriousSetting(true);
        try {
            this.chs.commitBulkChange(Collections.EMPTY_MAP);
            Assert.fail();
        }
        catch (BulkSettingException ex) {
            for (String key : comps.keySet()) {
                Assert.assertEquals((String)("submitted changes should have been dropped " + key), (long)0L, (long)this.chs.getSubmittedChangesForComponent(key).size());
            }
            Assert.assertTrue((String)ex.getCause().getMessage(), (boolean)ex.getCause().getMessage().contains("expected"));
        }
        ConfigurationInfo ci = this.chs.getConfigurationInfo();
        Assert.assertArrayEquals((String)"values should have been correctly applied for main", (Object[])this.changesOK, (Object[])comps.get("main").getConfValues());
        Assert.assertArrayEquals((String)"son1 has spurious changes", (Object[])new Object[]{null, 6, 8, 3.14}, (Object[])comps.get("son1").getConfValues());
        Assert.assertArrayEquals((String)"values should not have changed for son2", (Object[])this.initVals, (Object[])comps.get("son2").getConfValues());
        Assert.assertEquals((Object)ConfigurationState.DIRTY, (Object)this.chs.getConfigurationInfo().getConfigurationState());
        Assert.assertEquals((Object)"changed", (Object)ci.getCurrentValueForParameter("son1/hiddenParm"));
    }

    private void submitChanges(String component, Object[] changes) {
        this.chs.submitChange(component, "info", changes[0]);
        this.chs.submitChange(component, "min", changes[1]);
        this.chs.submitChange(component, "max", changes[2]);
        this.chs.submitChange(component, "value", changes[3]);
    }
}

