/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.Map;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;

public class BulkChangeComponent
implements ConfigurationBulkChangeHandler {
    @ConfigurationParameter
    private String info;
    @ConfigurationParameter
    private int min = 0;
    @ConfigurationParameter
    private int max = 10;
    @ConfigurationParameter
    private double value = 3.14;
    @ConfigurationParameter
    protected String hiddenParm = "init";
    private boolean spuriousValidation = false;
    private boolean spuriousSetting = false;

    public String getInfo() {
        return this.info;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public double getValue() {
        return this.value;
    }

    public void setSpuriousValidation(boolean b) {
        this.spuriousValidation = b;
    }

    public void setSpuriousSetting(boolean b) {
        this.spuriousSetting = b;
    }

    @ConfigurationParameterChanger
    public void setValue(double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException("no negative value");
        }
        this.value = value;
    }

    @ConfigurationParameterChanger
    public void setInfo(String info) {
        this.info = info;
    }

    public void validateBulkChange(Map<String, Object> parametersView) {
        int theMax;
        int theMin = (Integer)parametersView.get("min");
        if (theMin > (theMax = ((Integer)parametersView.get("max")).intValue())) {
            throw new IllegalArgumentException("min greater than max");
        }
        if (this.spuriousValidation) {
            this.value *= 2.0;
        }
    }

    public Map<String, Object> setBulkParameter(Map<String, Object> parametersView) {
        Object obj = parametersView.remove("max");
        if (obj != null) {
            int theMax = (Integer)obj;
            if (theMax > 100) {
                throw new IllegalArgumentException("exception at setting step : max cannot be greter than 100");
            }
            this.max = theMax;
        }
        if ((obj = parametersView.remove("min")) != null) {
            int theMin = (Integer)obj;
            if (theMin < 0) {
                throw new IllegalArgumentException("exception at setting step : min cannot be negative");
            }
            this.min = (Integer)obj;
        }
        if (this.spuriousSetting) {
            this.hiddenParm = "changed";
            this.min *= 2;
        }
        return parametersView;
    }

    public Object[] getConfValues() {
        return new Object[]{this.info, this.min, this.max, this.value};
    }
}

