package org.lsst.ccs.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * @author bamade
 */
// Date: 19/06/13

public class ConfigUtils {
    
    public static final String DEFAULT_CONFIG_NAME = "";
    public static final String DEFAULT_CAT = "";
    public static final String SAFE_CONFIG_NAME="safe";
    
    private ConfigUtils() {
    }
    
    // Utility methods to process configuration input String
    
    /**
     * Parses a string of tagged categories.
     *
     * @param categorySet
     * @param configNames
     * @throws IllegalArgumentException if one of the categories is not present in categorySet.
     * @return a map with category as keys and their configuration name as values
     */
    public static Map<String,String> parseConfigurationString(Set<String> categorySet, String... configNames){
        Map<String, String> res = new HashMap<>();
        for (String s : configNames){
            if (s.isEmpty()){
                res.put(DEFAULT_CAT, DEFAULT_CONFIG_NAME);
            } else if (!s.contains(":")){
                res.put(DEFAULT_CAT, s);
            } else {
                String[] keyVal = s.split(":",-1);
                if (keyVal.length != 2) throw new IllegalArgumentException("wrong configuration string representation : " + Arrays.toString(keyVal));
                if (categorySet != null){
                    if (!categorySet.contains(keyVal[0])) throw new IllegalArgumentException("unexisting category " + keyVal[0]);
                }
                res.put(keyVal[0],keyVal[1]);
                    }
                }
        return res;
    }

    public static Map<String,String> parseConfigurationStringWithDefaults(Set<String> categories, String ... taggedCategories){
        Map<String,String> res = new HashMap();
        for (String cat : categories){
            res.put(cat, DEFAULT_CONFIG_NAME);
        }
        res.putAll(parseConfigurationString(categories, taggedCategories));
        return res;
    }

    public static Set<String> parseCategories(Set<String> categorySet, String ... categories){
        Set<String> res = new HashSet();
        for (String cat : categories) {
            if (!categorySet.contains(cat)) {
                throw new IllegalArgumentException("unexisting category " + cat);
            }
            res.add(cat);
        }
        return res;
    }
}
