package org.lsst.ccs.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;

/**
 * Handles a category of parameters.
 * @author LSST CCS Team
 */
class CategoryHandler {
    
    private final String category;
    private String tag;
    private final Set<ConfigurationParameterHandler> parameters = new HashSet<>();
    
    CategoryHandler(String category) {
        this.category = category;
    }
    
    void addParameterHandler(ConfigurationParameterHandler cph) {
        parameters.add(cph);
    }
    
    public boolean isDirty() {
        return parameters.stream()
                .map(ConfigurationParameterHandler::isDirty) 
                .reduce(false, (a,b) -> a||b);
    }
    
    public String getTag() {
        return tag;
    }
    
   public String getCategory() {
       return category;
   } 
   
   public void setRunningConfiguration(String tag) {
       this.tag = tag;
       for (ConfigurationParameterHandler cph : parameters) {
           cph.commitValue(tag.equals(ConfigUtils.SAFE_CONFIG_NAME));
       }
   }
    
   public List<ConfigurationParameterInfo> getConfigurationParameterInfo() {
        List<ConfigurationParameterInfo> res = new ArrayList<>();
        for (ConfigurationParameterHandler cph : parameters) {
            res.add(cph.getParameterInfo());
        }
        return res;
    }
   
   public Collection<ConfigurationParameterHandler> getParameters() {
       return Collections.unmodifiableSet(parameters);
   }
}
