package org.lsst.ccs.config;


import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * Writes properties files in memory.
 * Use for test purposes only
 * @author The LSST CCS Teams
 */

class InMemoryWriterProvider implements WriterProvider {
    
    private final Map <String, ByteArrayOutputStream> propertiesMap = new HashMap<String, ByteArrayOutputStream>();
    
    /**
     * Private default constructor
     */
    InMemoryWriterProvider(){
        
    }
    
    @Override
    public PrintWriter getPrintWriter(String configName, String tagName, String categoryName) throws IOException {
        String configFileName = new ConfigurationFileName(tagName, configName, categoryName).getFullName();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Writer writer = new OutputStreamWriter(bos) ;
        propertiesMap.put(configFileName, bos);
        return new PrintWriter(writer) ;
    }
    
    public Properties getConfigurationProperties(String configName, String tag, String cat) throws IOException {
        String configFileName = new ConfigurationFileName(tag, configName, cat).getFullName();
        Properties props = new Properties() ;
        ByteArrayOutputStream bos = propertiesMap.get(configFileName);
        if (bos == null) {
            return null;
        }
        byte[] array = bos.toByteArray() ;
        
        props.load(new InputStreamReader(new ByteArrayInputStream(array)));
        
        return props ;
    }
    
    @Override
    public Set<String> findMatchingConfigurations(String pattern) {
        Pattern p = Pattern.compile(pattern);
        return propertiesMap.keySet().stream()
                .filter(p.asPredicate())
                .collect(Collectors.toSet());
    }

}