package org.lsst.ccs.config;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;

/**
 * Subsystem access to configuration information.
 * <P/>
 * <B>BEWARE</B>: there are two potential sources for description and configuration
 * (database or/and local file) and two potential sink when registering changes
 * (database or/and local file). There may be potential concurrency issues (mostly when dealing
 * with the remote database) and so commands that fire the modifications should be sure
 * to get a proper lock from the lock manager.
 *
 * @author bamade
 */
// Date: 03/10/12

public interface ConfigurationProxy {
    
    /**
     * Changes made in the specified categories are saved under the newly specified
     * name for this category, changes on parameters that belong to other categories
     * are left unchanged.
     * @param categoryName
     * @param configName
     * @param values
     * @throws ConfigurationServiceException if the configuration service is not available.
     */
    void saveChangesForCategoriesAs(Map<String, String> taggedCategories, List<ConfigurationParameterInfo> values) throws ConfigurationServiceException ;
    
    /**
     * For each pair 'category:configuration' in taggedCategories, the category is loaded
     * with its specified configuration, categories that are not mentioned are left untouched.
     * The configuration context remains active
     * @param taggedCategories a list of tagged categories
     * @return a map of component name to properties
     * @throws org.lsst.ccs.framework.ConfigurationServiceException 
     */
    Map<String, Properties> loadCategories(Map<String,String> taggedCategories) throws ConfigurationServiceException;
    
    
    Set<String> findAvailableConfigurationsForCategory(String category);
    
    /**
     * Checks whether the configuration service is unavailable or not.
     * @return true if the configuration service is available, false otherwise.
     */
    boolean isAvailable();

}
