package org.lsst.ccs.config.utilities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.config.NamesAndTag;

/**
 * @author bamade
 */
// Date: 19/06/13

public class ConfigUtils {
    
    public static final String DEFAULT_CONFIG_NAME = "";
    public static final String DEFAULT_CAT = "";
    
    private ConfigUtils() {
    }
    
    /**
     * gets subsystem name, configName and tag name from pathName
     * @param pathName
     * @return a {@code NamesAndTag} object structuring the names extracted from
     * the path name.
     */
    public static NamesAndTag namesFromPath(String pathName) {
        //split name
        String subsystemName = "" ;
        String configName = "" ;
        String tag = "" ;
        String cat = "";
        if (isAPath(pathName) ){ // pathName is a config filename
            int indexDot =  pathName.lastIndexOf('.');
            int lastPath = pathName.lastIndexOf('/');
            String rawName = pathName.substring(lastPath + 1, indexDot);
            String[] elements = rawName.split("_");
            //falltrough !
                switch(elements.length) {
                    case 3: configName = elements[2]+":";
                        cat = elements[2];
                    case 2: configName += elements[1] ;
                    case 1: tag = elements[0] ;
                }
        } else { // pathName is a config name
        configName = pathName;
        }
        return new NamesAndTag(subsystemName,configName,tag,cat);
    }
    
    private static boolean isAPath(String string){
        if (string == null )return false;
        int lastDot = string.lastIndexOf('.');
        int lastPath = string.lastIndexOf('/');
        return lastDot > lastPath;
    }
    
    
    // Utility methods to process configuration input String
    
    /**
     * ParseConfigurationString without checking for category consistency
     *
     * @param configNames
     * @return a map with category as keys and their configuration name as values
     */
    public static Map<String,String> rawParseConfigurationString(String... configNames){
        return parseConfigurationString(null, configNames);
    }

    /**
     * Parses a string of tagged categories.
     *
     * @param categorySet
     * @param configNames
     * @throws IllegalArgumentException if one of the categories is not present in categorySet.
     * @return a map with category as keys and their configuration name as values
     */
    public static Map<String,String> parseConfigurationString(Set<String> categorySet, String... configNames){
        Map<String, String> res = new HashMap<>();
        for (String s : configNames){
            if (s.isEmpty()){
                res.put(DEFAULT_CAT, DEFAULT_CONFIG_NAME);
            } else if (!s.contains(":")){
                res.put(DEFAULT_CAT, s);
            } else {
                String[] keyVal = s.split(":",-1);
                if (keyVal.length != 2) throw new IllegalArgumentException("configuration " + keyVal.length);
                if (categorySet != null){
                    if (!categorySet.contains(keyVal[0])) throw new IllegalArgumentException("unexisting category " + keyVal[0]);
                }
                res.put(keyVal[0],keyVal[1]);
                    }
                }
        return res;
    }

    public static Map<String,String> parseConfigurationStringWithDefaults(Set<String> categories, String ... taggedCategories){
        Map<String,String> res = new HashMap();
        for (String cat : categories){
            res.put(cat, DEFAULT_CONFIG_NAME);
        }
        res.putAll(parseConfigurationString(categories, taggedCategories));
        return res;
    }

    public static Set<String> parseCategories(Set<String> categorySet, String ... categories){
        Set<String> res = new HashSet();
        for (String cat : categories) {
            if (!categorySet.contains(cat)) {
                throw new IllegalArgumentException("unexisting category " + cat);
            }
            res.add(cat);
        }
        return res;
    }
}
