/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public interface WriterProvider {
    public PrintWriter getPrintWriter(String var1, String var2, String var3) throws IOException;

    public Properties getConfigurationProperties(String var1, String var2, String var3) throws IOException;

    default public Set<String> findAvailableConfigurationsForCategory(String tagName, String category) {
        String pattern = tagName;
        pattern = category.isEmpty() ? pattern + "(_[^_]+?)??" : pattern + "_.*?_" + category;
        pattern = pattern + "\\.properties";
        Set<String> fullNames = this.findMatchingConfigurations(pattern);
        return fullNames.stream().map(s -> new ConfigurationFileName(tagName, (String)s).configName).collect(Collectors.toSet());
    }

    public Set<String> findMatchingConfigurations(String var1);

    public static class ConfigurationFileName {
        private final String tagName;
        private final String configName;
        private final String catName;
        private final String fullName;

        ConfigurationFileName(String tagName, String configName, String categoryName) {
            this.tagName = tagName;
            this.configName = configName;
            this.catName = categoryName;
            String baseName = tagName;
            if (configName.isEmpty()) {
                if (!this.catName.isEmpty()) {
                    baseName = baseName + "__" + this.catName;
                }
            } else {
                baseName = baseName + "_" + configName;
                if (!this.catName.isEmpty()) {
                    baseName = baseName + "_" + this.catName;
                }
            }
            this.fullName = baseName + ".properties";
        }

        ConfigurationFileName(String tagName, String fullName) {
            this.tagName = tagName;
            String trimmed = fullName.replace(".properties", "").replace(tagName, "");
            String[] split = trimmed.split("_");
            switch (split.length) {
                case 1: {
                    this.configName = "";
                    this.catName = "";
                    break;
                }
                case 2: {
                    this.configName = split[1];
                    this.catName = "";
                    break;
                }
                case 3: {
                    this.configName = split[1];
                    this.catName = split[2];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("file name is not a configuration file name : " + fullName);
                }
            }
            this.fullName = fullName;
        }

        public String getConfigName() {
            return this.configName;
        }

        public String getFullName() {
            return this.fullName;
        }
    }
}

