/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.lsst.ccs.CCSCst;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.config.AConfigProfile;
import org.lsst.ccs.config.ASubsystemDescription;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.ConfigurationProxy;
import org.lsst.ccs.config.FileWriterProvider;
import org.lsst.ccs.config.InMemoryWriterProvider;
import org.lsst.ccs.config.PackCst;
import org.lsst.ccs.config.ParameterConfiguration;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.ParameterPath;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.config.WriterProvider;
import org.lsst.ccs.framework.ConfigurationServiceException;
import org.lsst.ccs.utilities.conv.TypeUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class LocalConfigurationProxy
implements ConfigurationProxy {
    private static Logger log = Logger.getLogger((String)"org.lsst.ccs.config");
    private static WriterProvider writerProvider = null;
    private final ASubsystemDescription subsystemDescription;
    private final String tagName;
    private final Map<String, AConfigProfile> configProfileMap = new HashMap<String, AConfigProfile>();
    Logger logger = Logger.getLogger((String)"org.lsst.ccs.config");

    protected static WriterProvider getWriterProvider() {
        if (writerProvider == null) {
            writerProvider = System.getProperty("org.lsst.ccs.config.WriterProvier", "").equals("org.lsst.ccs.config.InMemoryWriterProvider") ? new InMemoryWriterProvider() : new FileWriterProvider();
        }
        return writerProvider;
    }

    public LocalConfigurationProxy(SubsystemDescription subsystemDesc) {
        LocalConfigurationProxy.getWriterProvider();
        this.subsystemDescription = (ASubsystemDescription)subsystemDesc;
        this.tagName = this.subsystemDescription.getTag();
    }

    @Override
    public Set<String> getCategorySet() {
        return this.subsystemDescription.getCategorySet();
    }

    @Override
    public Map.Entry<ConfigurationState, Set<ParameterConfiguration>> getInitialParameterConfigurations(Map<String, String> taggedCategories) {
        CCSCst.LOG_TODO.fine((Object)"TODO: DAO at creation of SubsystemDescription should also be able to interact with remote database (switch between local and remote?)");
        boolean exceptionThrown = false;
        for (Map.Entry<String, String> entry : taggedCategories.entrySet()) {
            AConfigProfile profileForCat;
            String cat = entry.getKey();
            String tag = entry.getValue();
            Properties configProps = null;
            try {
                configProps = writerProvider.getConfigurationProperties(tag, this.tagName, cat);
                if (configProps == null && !tag.equals("")) {
                    throw new IllegalArgumentException("could not find configuration file " + tag + " for category " + cat);
                }
                profileForCat = this.createConfigProfileOutOfProperties(configProps, cat, tag);
            }
            catch (IOException ex) {
                exceptionThrown = true;
                profileForCat = this.createConfigProfileOutOfProperties(null, cat, "");
            }
            this.configProfileMap.put(profileForCat.getCategoryName(), profileForCat);
        }
        return new AbstractMap.SimpleEntry<ConfigurationState, Set<ParameterConfiguration>>(exceptionThrown ? ConfigurationState.UNCONFIGURED : ConfigurationState.CONFIGURED, new HashSet<ParameterConfiguration>(this.getParameterConfigurations()));
    }

    @Override
    public String getTagName() {
        return this.tagName;
    }

    @Override
    public synchronized ConfigurationInfo buildConfigurationInfo(ConfigurationState configState, Set<ParameterPath> recentChangesPaths) {
        HashMap<String, String> tags = new HashMap<String, String>();
        HashMap<String, Boolean> hasCatChanges = new HashMap<String, Boolean>();
        ArrayList<ConfigurationParameterInfo> parametersView = new ArrayList<ConfigurationParameterInfo>();
        ArrayList<String> recentChanges = new ArrayList<String>();
        for (ConfigProfile configProfile : this.configProfileMap.values()) {
            String category = configProfile.getCategoryName();
            tags.put(category, configProfile.getConfigName());
            hasCatChanges.put(configProfile.getCategoryName(), configProfile.isDirty());
            for (ParameterDescription parmDesc : this.subsystemDescription.getParamDescriptions().stream().filter(desc -> desc.getCategory().equals(category)).collect(Collectors.toSet())) {
                ParameterConfiguration parmConfig = configProfile.fetch(parmDesc);
                ConfigurationParameterInfo configParameterInfo = parmConfig != null ? new ConfigurationParameterInfo(parmDesc.getPath().toString(), parmDesc.getCategory(), parmDesc.getTypeName(), parmConfig.getConfiguredValue(), parmConfig.getValueAt(PackCst.STILL_VALID), parmConfig.hasChanged()) : new ConfigurationParameterInfo(parmDesc.getPath().toString(), parmDesc.getCategory(), parmDesc.getTypeName(), parmDesc.getDefaultValue(), parmDesc.getDefaultValue(), false);
                parametersView.add(configParameterInfo);
                if (!recentChangesPaths.contains(parmDesc.getPath())) continue;
                recentChanges.add(configParameterInfo.getPathName());
            }
        }
        return new ConfigurationInfo(configState, this.tagName, tags, hasCatChanges, parametersView, recentChanges);
    }

    @Override
    public Boolean isParameterConfigurable(String componentName, String parameterName) {
        ParameterPath path = new ParameterPath(componentName, "", parameterName);
        ParameterDescription parameterDescription = this.subsystemDescription.fetch(path);
        return parameterDescription != null;
    }

    @Override
    public synchronized void notifyParameterChange(String componentName, String parameterName, String value) {
        ParameterPath parameterPath = new ParameterPath(componentName, "", parameterName);
        String category = this.subsystemDescription.fetch(parameterPath).getCategory();
        this.configProfileMap.get(category).temporaryChangeConfigurationValue(parameterPath.toString(), System.currentTimeMillis(), value);
    }

    @Override
    public synchronized void notifyUncheckedParameterChange(String componentName, String parameterName, Object value) {
        ParameterPath parameterPath = new ParameterPath(componentName, "", parameterName);
        String strValue = value instanceof String ? (String)value : TypeUtils.stringify((Object)value);
        String category = this.subsystemDescription.fetch(parameterPath).getCategory();
        this.configProfileMap.get(category).temporaryChangeConfigurationValue(parameterPath.toString(), System.currentTimeMillis(), strValue);
    }

    @Override
    public synchronized void saveChangesForCategoriesAs(Map<String, String> taggedCategories) throws ConfigurationServiceException {
        Map<String, Set> parmDescGroupedByCategory = this.subsystemDescription.getParamDescriptions().stream().collect(Collectors.groupingBy(ParameterDescription::getCategory, Collectors.toCollection(TreeSet::new)));
        for (Map.Entry<String, String> taggedCategory : taggedCategories.entrySet()) {
            String cat = taggedCategory.getKey();
            String tag = taggedCategory.getValue();
            try {
                ConfigProfile profileForCat = this.configProfileMap.get(cat);
                TreeSet<? extends ParameterConfiguration> modifiedParameters = new TreeSet<ParameterConfiguration>(profileForCat.getModifiedParameters());
                if (modifiedParameters.isEmpty() && tag.equals(profileForCat.getConfigName())) continue;
                PrintWriter printWriter = writerProvider.getPrintWriter(tag, this.tagName, cat);
                for (ParameterConfiguration parameterConfiguration : modifiedParameters) {
                    String currentValue = parameterConfiguration.getValueAt(PackCst.STILL_VALID);
                    boolean commentOut = currentValue.equals(parameterConfiguration.getDescription().getDefaultValue());
                    if (commentOut) continue;
                    printWriter.println(parameterConfiguration.getDescription().toPropertyString(currentValue, commentOut));
                }
                for (ParameterDescription parameterDescription : parmDescGroupedByCategory.get(cat)) {
                    if (modifiedParameters.contains(parameterDescription)) continue;
                    printWriter.println(parameterDescription.toPropertyString(parameterDescription.getDefaultValue(), true));
                }
                printWriter.flush();
                printWriter.close();
                this.saveModifications(cat, tag);
            }
            catch (IOException ex) {
                throw new ConfigurationServiceException("configuration service unavailable", (Throwable)ex);
            }
        }
    }

    @Override
    public Map<String, String> getTaggedCategoriesForCats(Set<String> categories) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (String category : categories) {
            res.put(category, this.configProfileMap.get(category).getConfigName());
        }
        return res;
    }

    private synchronized void saveModifications(String category, String configName) {
        AConfigProfile oldProfile = this.configProfileMap.get(category);
        AConfigProfile newProfile = new AConfigProfile(oldProfile, false, configName);
        this.configProfileMap.put(category, newProfile);
    }

    @Override
    public synchronized void saveModifications(Map<String, String> taggedCategories) {
        for (Map.Entry<String, String> entry : taggedCategories.entrySet()) {
            this.saveModifications(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Map<String, String> getCurrentValuesForComponent(String componentName, Set<String> categories) {
        if (categories.isEmpty()) {
            return this.subsystemDescription.getParamDescriptionMap().entrySet().stream().filter(entry -> ((ParameterPath)entry.getKey()).getComponentName().equals(componentName)).collect(Collectors.toMap(entry -> ((ParameterPath)entry.getKey()).getParameterName(), entry -> this.configProfileMap.get(((ParameterDescription)entry.getValue()).getCategory()).getValueAt((ParameterPath)entry.getKey(), PackCst.STILL_VALID)));
        }
        return this.subsystemDescription.getParamDescriptionMap().entrySet().stream().filter(entry -> ((ParameterPath)entry.getKey()).getComponentName().equals(componentName) && categories.contains(((ParameterDescription)entry.getValue()).getCategory())).collect(Collectors.toMap(entry -> ((ParameterPath)entry.getKey()).getParameterName(), entry -> this.configProfileMap.get(((ParameterDescription)entry.getValue()).getCategory()).getValueAt((ParameterPath)entry.getKey(), PackCst.STILL_VALID)));
    }

    protected static void setWriterProvider(WriterProvider wp) {
        writerProvider = wp;
    }

    @Override
    public boolean isDirty() {
        return this.configProfileMap.values().stream().map(ConfigProfile::isDirty).reduce(false, (a, b) -> a != false || b != false);
    }

    @Override
    public Map<String, Properties> loadCategories(Map<String, String> taggedCategories) throws ConfigurationServiceException {
        if (taggedCategories.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Properties> res = new HashMap<String, Properties>();
        for (Map.Entry<String, String> entry : taggedCategories.entrySet()) {
            String cat = entry.getKey();
            String tag = entry.getValue();
            try {
                Properties configProps = writerProvider.getConfigurationProperties(tag, this.tagName, cat);
                if (configProps == null && !tag.equals("")) {
                    throw new IllegalArgumentException("could not find configuration file " + tag + " for category " + cat);
                }
                AConfigProfile newConfigProfile = this.createConfigProfileOutOfProperties(configProps, cat, tag);
                Map<String, Properties> changesForCategory = this.buildChangesBetweenProfiles(this.configProfileMap.get(cat), newConfigProfile);
                for (Map.Entry<String, Properties> e : changesForCategory.entrySet()) {
                    Properties changesForComponent = (Properties)res.get(e.getKey());
                    if (changesForComponent == null) {
                        changesForComponent = new Properties();
                        res.put(e.getKey(), changesForComponent);
                    }
                    changesForComponent.putAll((Map<?, ?>)e.getValue());
                }
            }
            catch (IOException ex) {
                throw new ConfigurationServiceException("configuration service problem", (Throwable)ex);
            }
        }
        return res;
    }

    private Map<String, Properties> buildChangesBetweenProfiles(ConfigProfile oldProfile, ConfigProfile newProfile) {
        String parameterName;
        ParameterPath path;
        Set<? extends ParameterConfiguration> newChanges = newProfile.getModifiedParameters();
        HashSet<? extends ParameterConfiguration> oldChanges = new HashSet<ParameterConfiguration>(oldProfile.getModifiedParameters());
        HashMap<String, Properties> res = new HashMap<String, Properties>();
        for (ParameterConfiguration parameterConfiguration : newChanges) {
            oldChanges.remove(parameterConfiguration);
            path = parameterConfiguration.getPath();
            parameterName = path.getParameterName();
            String value = parameterConfiguration.getConfiguredValue();
            String oldValue = oldProfile.getValueAt(path, PackCst.STILL_VALID);
            if (oldValue.equals(value)) continue;
            Properties changesForComponent = (Properties)res.get(path.getComponentName());
            if (changesForComponent == null) {
                changesForComponent = new Properties();
                res.put(path.getComponentName(), changesForComponent);
            }
            changesForComponent.setProperty(parameterName, value);
        }
        for (ParameterConfiguration parameterConfiguration : oldChanges) {
            path = parameterConfiguration.getPath();
            parameterName = path.getParameterName();
            String defaultValue = parameterConfiguration.getDescription().getDefaultValue();
            Properties changesForComponent = (Properties)res.get(path.getComponentName());
            if (changesForComponent == null) {
                changesForComponent = new Properties();
                res.put(path.getComponentName(), changesForComponent);
            }
            changesForComponent.setProperty(parameterName, defaultValue);
        }
        return res;
    }

    private AConfigProfile createConfigProfileOutOfProperties(Properties configProps, String categoryName, String configName) {
        AConfigProfile res = new AConfigProfile(this.subsystemDescription, categoryName, configName);
        if (configProps != null) {
            for (String name : configProps.stringPropertyNames()) {
                res.addParameterConfiguration(name, configProps.getProperty(name));
            }
        }
        return res;
    }

    public ConfigProfile getProfileForCat(String categoryName) {
        return this.configProfileMap.get(categoryName);
    }

    private Set<ParameterConfiguration> getParameterConfigurations() {
        HashSet<ParameterConfiguration> res = new HashSet<ParameterConfiguration>();
        for (String category : this.subsystemDescription.getCategorySet()) {
            res.addAll(this.configProfileMap.get(category).getParameterConfigurations());
        }
        return res;
    }

    @Override
    public void setDefaultValueForParameter(String componentName, String parameterName, Object val) {
        this.subsystemDescription.paramDescriptions.get(new ParameterPath(componentName, "", parameterName)).getParameterBase().setDefaultValue(TypeUtils.stringify((Object)val));
    }

    @Override
    public void writeMissingDefaultConfigs() {
        Map<String, Set> parmDescs = this.subsystemDescription.getParamDescriptions().stream().collect(Collectors.groupingBy(ParameterDescription::getCategory, Collectors.toCollection(TreeSet::new)));
        for (Map.Entry<String, Set> entry : parmDescs.entrySet()) {
            String cat = entry.getKey();
            try {
                if (writerProvider.getConfigurationProperties("", this.tagName, cat) != null) continue;
                PrintWriter writer = writerProvider.getPrintWriter("", this.tagName, cat);
                for (ParameterDescription parmDesc : entry.getValue()) {
                    writer.println(parmDesc.toPropertyString(parmDesc.getDefaultValue(), true));
                }
                writer.flush();
                writer.close();
            }
            catch (IOException ex) {
                this.logger.warn((Object)("could not write default configuration file for category : " + cat));
            }
        }
    }

    @Override
    public Set<String> findAvailableConfigurationsForCategory(String category) {
        return writerProvider.findAvailableConfigurationsForCategory(this.tagName, category);
    }
}

