/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.lsst.ccs.config.AParameterDescription;
import org.lsst.ccs.config.AValueEvent;
import org.lsst.ccs.config.ParameterConfiguration;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.ValueEvent;

@Entity
class AParameterConfiguration
extends ParameterConfiguration
implements Cloneable {
    private static final long serialVersionUID = 8134633715625475333L;
    @Id
    @GeneratedValue
    private long id;
    @ManyToOne(fetch=FetchType.EAGER)
    private AParameterDescription parameterDescription;
    private boolean copy;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private List<AValueEvent> valueEvents;

    AParameterConfiguration() {
    }

    AParameterConfiguration(AParameterDescription parameterDescription) {
        super(parameterDescription.getParameterBase().getDefaultValue());
        this.parameterDescription = parameterDescription;
    }

    AParameterConfiguration(AParameterDescription parameterDescription, String value) {
        this.parameterDescription = parameterDescription;
        this.modifyValue(value);
    }

    AParameterConfiguration(AParameterConfiguration other, boolean copyEvents) {
        this(other.getParameterDescription(), other.getConfiguredValue());
        if (other.hasChanged()) {
            int size;
            List<? extends ValueEvent> eventList = other.getValueEvents();
            if (copyEvents) {
                if (eventList != null) {
                    for (ValueEvent valueEvent : eventList) {
                        this.addValueEvent(valueEvent);
                    }
                }
                this.copy = true;
            } else if (eventList != null && (size = eventList.size()) > 0) {
                ValueEvent valueEvent = eventList.get(size - 1);
                this.modifyValue(valueEvent.getValue());
            }
        }
    }

    public static AParameterConfiguration copyWithoutEvents(ParameterConfiguration other) {
        throw new UnsupportedOperationException("copy without events (general)");
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    protected void setId(long id) {
        this.id = id;
    }

    @Override
    public ParameterDescription getDescription() {
        return this.parameterDescription;
    }

    @Override
    public List<? extends ValueEvent> getValueEvents() {
        return this.valueEvents;
    }

    void setValueEvents(List<AValueEvent> valueEventsList) {
        this.valueEvents = valueEventsList;
    }

    public final void addValueEvent(ValueEvent event) {
        if (!(event instanceof AValueEvent)) {
            throw new IllegalArgumentException("trying to add a deprecated ValueEvent");
        }
        AValueEvent anEvent = (AValueEvent)event;
        if (this.valueEvents == null) {
            this.valueEvents = new ArrayList<AValueEvent>();
        }
        this.valueEvents.add(anEvent);
    }

    AParameterDescription getParameterDescription() {
        return this.parameterDescription;
    }

    void setParameterDescription(AParameterDescription parameterDescription) {
        this.parameterDescription = parameterDescription;
    }

    public boolean isCopy() {
        return this.copy;
    }

    void setCopy(boolean copy) {
        this.copy = copy;
    }

    public AParameterConfiguration clone() {
        AParameterConfiguration res = null;
        try {
            res = (AParameterConfiguration)super.clone();
            if (this.valueEvents != null) {
                for (AValueEvent event : this.valueEvents) {
                    res.addValueEvent(event);
                }
            }
            res.setCopy(true);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return res;
    }
}

