/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.config.Factories;
import org.lsst.ccs.config.InMemoryWriterProvider;
import org.lsst.ccs.config.LocalConfigurationProxy;
import org.lsst.ccs.config.ParameterBase;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.config.WriterProvider;

public class LocalConfigurationProxyTest {
    private static SubsystemDescription subDesc;
    private static final String[] cats;
    private static final String subName = "subName";
    private static final String tagName = "subTag";
    private WriterProvider writerProvider;

    @BeforeClass
    public static void setupClass() {
        subDesc = Factories.createRawSubsystemDescription((String)subName, (String)tagName, (Serializable)((Object)""));
        ArrayList<ParameterDescription> parmDescs = new ArrayList<ParameterDescription>();
        ParameterBase parmBase = new ParameterBase("comp1", "", "parmD", "java.lang.Integer", "0");
        parmDescs.add(Factories.createParameterDescription((ParameterBase)parmBase, (String)"", (String)"", (String)cats[0], (int)0));
        parmBase = new ParameterBase("comp1", "", "parmA", "java.lang.Integer", "0");
        parmDescs.add(Factories.createParameterDescription((ParameterBase)parmBase, (String)"", (String)"", (String)cats[1], (int)0));
        parmBase = new ParameterBase("comp1", "", "parmB", "java.lang.Integer", "0");
        parmDescs.add(Factories.createParameterDescription((ParameterBase)parmBase, (String)"", (String)"", (String)cats[2], (int)0));
        parmBase = new ParameterBase("comp2", "", "parmD", "java.lang.Integer", "0");
        parmDescs.add(Factories.createParameterDescription((ParameterBase)parmBase, (String)"", (String)"", (String)cats[0], (int)0));
        parmBase = new ParameterBase("comp2", "", "parmA", "java.lang.Double", "0");
        parmDescs.add(Factories.createParameterDescription((ParameterBase)parmBase, (String)"", (String)"", (String)cats[1], (int)0));
        parmBase = new ParameterBase("comp2", "", "parmB", "java.lang.Integer", "0");
        parmDescs.add(Factories.createParameterDescription((ParameterBase)parmBase, (String)"", (String)"", (String)cats[2], (int)0));
        parmBase = new ParameterBase("comp3", "", "parmD", "java.lang.Integer", "0");
        parmDescs.add(Factories.createParameterDescription((ParameterBase)parmBase, (String)"", (String)"", (String)cats[0], (int)0));
        parmBase = new ParameterBase("comp3", "", "parmA", "java.lang.Integer", "0");
        parmDescs.add(Factories.createParameterDescription((ParameterBase)parmBase, (String)"", (String)"", (String)cats[1], (int)0));
        parmBase = new ParameterBase("comp3", "", "parmB", "java.lang.Integer", "0");
        parmDescs.add(Factories.createParameterDescription((ParameterBase)parmBase, (String)"", (String)"", (String)cats[2], (int)0));
        subDesc.addParameterDescriptions(parmDescs);
    }

    @Before
    public void initTest() {
        this.writerProvider = new InMemoryWriterProvider();
        LocalConfigurationProxy.setWriterProvider((WriterProvider)this.writerProvider);
    }

    @After
    public void tearDown() {
        LocalConfigurationProxy.setWriterProvider(null);
    }

    @Test
    public void testGetInitialParameterConfiguration() throws Exception {
        subDesc.setTag("testGetInitial");
        LocalConfigurationProxy proxy = new LocalConfigurationProxy(subDesc);
        Set categorySet = proxy.getCategorySet();
        Assert.assertEquals((long)cats.length, (long)categorySet.size());
        Assert.assertTrue((boolean)categorySet.containsAll(Arrays.asList(cats)));
        HashMap<String, String> taggedCategories = new HashMap<String, String>();
        String[] tags = new String[]{"", "", "conf1"};
        for (int i = 0; i < cats.length; ++i) {
            taggedCategories.put(cats[i], tags[i]);
        }
        try {
            Map.Entry res = proxy.getInitialParameterConfigurations(taggedCategories);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        tags = new String[]{"", "", ""};
        for (int i = 0; i < cats.length; ++i) {
            taggedCategories.put(cats[i], tags[i]);
        }
        Map.Entry res = proxy.getInitialParameterConfigurations(taggedCategories);
        Assert.assertEquals((Object)ConfigurationState.CONFIGURED, res.getKey());
        Assert.assertEquals((long)0L, (long)((Set)res.getValue()).size());
        PrintWriter printWriter = this.writerProvider.getPrintWriter("", subDesc.getTag(), cats[2]);
        printWriter.println("comp1//parmB=1");
        printWriter.println("comp2//parmB=1");
        printWriter.println("comp3//parmB=1");
        printWriter.flush();
        printWriter.close();
        res = proxy.getInitialParameterConfigurations(taggedCategories);
        Assert.assertEquals((Object)ConfigurationState.CONFIGURED, res.getKey());
        Assert.assertEquals((long)3L, (long)((Set)res.getValue()).size());
        printWriter = this.writerProvider.getPrintWriter("config1", subDesc.getTag(), cats[1]);
        printWriter.println("comp1//parmA=2");
        printWriter.println("comp2//parmA=2");
        printWriter.println("comp3//parmA=2");
        printWriter.flush();
        printWriter.close();
        taggedCategories.put(cats[1], "config1");
        res = proxy.getInitialParameterConfigurations(taggedCategories);
        Assert.assertEquals((Object)ConfigurationState.CONFIGURED, res.getKey());
        Assert.assertEquals((long)6L, (long)((Set)res.getValue()).size());
    }

    @Test
    public void testSaveConfiguration() throws Exception {
        subDesc.setTag("testSaveConfiguration");
        LocalConfigurationProxy proxy = new LocalConfigurationProxy(subDesc);
        HashMap<String, String> taggedCategories = new HashMap<String, String>();
        for (int i = 0; i < cats.length; ++i) {
            taggedCategories.put(cats[i], "");
        }
        proxy.getInitialParameterConfigurations(taggedCategories);
        Assert.assertFalse((boolean)proxy.isDirty());
        proxy.notifyParameterChange("comp3", "parmD", "1");
        proxy.notifyParameterChange("comp1", "parmA", "2");
        proxy.notifyParameterChange("comp2", "parmA", "2");
        proxy.notifyParameterChange("comp2", "parmB", "4");
        Assert.assertTrue((boolean)proxy.isDirty());
        taggedCategories.clear();
        taggedCategories.put("catB", "configB1");
        taggedCategories.put("catA", "configA1");
        proxy.saveChangesForCategoriesAs(taggedCategories);
        Assert.assertTrue((boolean)proxy.isDirty());
        Properties props = this.writerProvider.getConfigurationProperties("configB1", subDesc.getTag(), "catB");
        Assert.assertEquals((long)1L, (long)props.size());
        Assert.assertEquals((Object)"4", (Object)props.getProperty("comp2//parmB"));
        props = this.writerProvider.getConfigurationProperties("configA1", subDesc.getTag(), "catA");
        Assert.assertEquals((long)2L, (long)props.size());
        Assert.assertEquals((Object)"2", (Object)props.getProperty("comp1//parmA"));
        Assert.assertEquals((Object)"2", (Object)props.getProperty("comp2//parmA"));
        props = this.writerProvider.getConfigurationProperties("", subDesc.getTag(), "");
        if (props != null) {
            Assert.assertEquals((long)0L, (long)props.entrySet().size());
        }
        taggedCategories.clear();
        taggedCategories.put("", "config1");
        proxy.saveChangesForCategoriesAs(taggedCategories);
        Assert.assertFalse((boolean)proxy.isDirty());
        props = this.writerProvider.getConfigurationProperties("config1", subDesc.getTag(), "");
        Assert.assertEquals((long)1L, (long)props.size());
        Assert.assertEquals((Object)"1", (Object)props.getProperty("comp3//parmD"));
        taggedCategories.put("", "config2");
        proxy.saveChangesForCategoriesAs(taggedCategories);
        props = this.writerProvider.getConfigurationProperties("config2", subDesc.getTag(), "");
        Assert.assertEquals((long)1L, (long)props.size());
        Assert.assertEquals((Object)"1", (Object)props.getProperty("comp3//parmD"));
        proxy.notifyParameterChange("comp2", "parmA", "17");
        proxy.notifyParameterChange("comp3", "parmA", "17");
        taggedCategories.clear();
        taggedCategories.put("catA", "");
        proxy.saveChangesForCategoriesAs(taggedCategories);
        props = this.writerProvider.getConfigurationProperties("", subDesc.getTag(), "catA");
        Assert.assertEquals((long)3L, (long)props.size());
        Assert.assertEquals((Object)"2", (Object)props.getProperty("comp1//parmA"));
        Assert.assertEquals((Object)"17", (Object)props.getProperty("comp2//parmA"));
        Assert.assertEquals((Object)"17", (Object)props.getProperty("comp3//parmA"));
        proxy.writeMissingDefaultConfigs();
        props = this.writerProvider.getConfigurationProperties("", subDesc.getTag(), "catA");
        Assert.assertEquals((long)3L, (long)props.size());
        props = this.writerProvider.getConfigurationProperties("", subDesc.getTag(), "catB");
        Assert.assertEquals((long)0L, (long)props.size());
        props = this.writerProvider.getConfigurationProperties("", subDesc.getTag(), "");
        Assert.assertEquals((long)0L, (long)props.size());
    }

    @Test
    public void testLoadConfiguration() throws Exception {
        String tag = "testLoadConfiguration";
        subDesc.setTag(tag);
        LocalConfigurationProxy proxy = new LocalConfigurationProxy(subDesc);
        PrintWriter printWriter = this.writerProvider.getPrintWriter("configA1", subDesc.getTag(), cats[1]);
        printWriter.println("comp1//parmA=1");
        printWriter.println("comp3//parmA=1");
        printWriter.flush();
        printWriter.close();
        printWriter = this.writerProvider.getPrintWriter("configA2", subDesc.getTag(), cats[1]);
        printWriter.println("comp2//parmA=1");
        printWriter.flush();
        printWriter.close();
        printWriter = this.writerProvider.getPrintWriter("configB1", subDesc.getTag(), cats[2]);
        printWriter.println("comp1//parmB=1");
        printWriter.println("comp3//parmB=1");
        printWriter.flush();
        printWriter.close();
        printWriter = this.writerProvider.getPrintWriter("configB2", subDesc.getTag(), cats[2]);
        printWriter.println("comp2//parmB=1");
        printWriter.flush();
        printWriter.close();
        printWriter = this.writerProvider.getPrintWriter("configD1", subDesc.getTag(), cats[0]);
        printWriter.println("comp1//parmD=1");
        printWriter.println("comp3//parmD=1");
        printWriter.flush();
        printWriter.close();
        HashMap<String, String> taggedCategories = new HashMap<String, String>();
        taggedCategories.put("catA", "configA1");
        taggedCategories.put("catB", "configB1");
        taggedCategories.put("", "");
        proxy.getInitialParameterConfigurations(taggedCategories);
        Assert.assertFalse((boolean)proxy.isDirty());
        taggedCategories.clear();
        taggedCategories.put("catA", "configA2");
        taggedCategories.put("catB", "configB2");
        taggedCategories.put("", "configD1");
        Map changesToPerform = proxy.loadCategories(taggedCategories);
        Assert.assertEquals((long)3L, (long)changesToPerform.size());
        Properties props = (Properties)changesToPerform.get("comp1");
        Assert.assertEquals((long)3L, (long)props.size());
        Assert.assertEquals((Object)"0", (Object)props.getProperty("parmA"));
        Assert.assertEquals((Object)"0", (Object)props.getProperty("parmB"));
        Assert.assertEquals((Object)"1", (Object)props.getProperty("parmD"));
        props = (Properties)changesToPerform.get("comp2");
        Assert.assertEquals((long)2L, (long)props.size());
        Assert.assertEquals((Object)"1", (Object)props.getProperty("parmA"));
        Assert.assertEquals((Object)"1", (Object)props.getProperty("parmB"));
        props = (Properties)changesToPerform.get("comp3");
        Assert.assertEquals((long)3L, (long)props.size());
        Assert.assertEquals((Object)"0", (Object)props.getProperty("parmA"));
        Assert.assertEquals((Object)"0", (Object)props.getProperty("parmB"));
        Assert.assertEquals((Object)"1", (Object)props.getProperty("parmD"));
        String configNames = ((InMemoryWriterProvider)this.writerProvider).printConfigNames();
        System.out.println("content in memory : " + configNames);
        Set configs = proxy.findAvailableConfigurationsForCategory(cats[1]);
        Assert.assertEquals((String)("matched : " + Arrays.toString(configs.toArray()) + " in " + configNames), (long)2L, (long)configs.size());
        Assert.assertTrue((String)Arrays.toString(configs.toArray()), (boolean)configs.contains("configA1"));
        Assert.assertTrue((String)Arrays.toString(configs.toArray()), (boolean)configs.contains("configA2"));
        configs = proxy.findAvailableConfigurationsForCategory(cats[2]);
        Assert.assertEquals((String)("matched : " + Arrays.toString(configs.toArray()) + " in " + configNames), (long)2L, (long)configs.size());
        Assert.assertTrue((String)Arrays.toString(configs.toArray()), (boolean)configs.contains("configB1"));
        Assert.assertTrue((String)Arrays.toString(configs.toArray()), (boolean)configs.contains("configB2"));
        configs = proxy.findAvailableConfigurationsForCategory(cats[0]);
        Assert.assertEquals((String)("matched : " + Arrays.toString(configs.toArray()) + " in " + configNames), (long)1L, (long)configs.size());
        Assert.assertTrue((String)Arrays.toString(configs.toArray()), (boolean)configs.contains("configD1"));
    }

    @Test
    public void testFindAvailableConfigurations() throws Exception {
        String[][] configNames;
        for (String[] config : configNames = new String[][]{{"desc1", "configA1", "catA"}, {"desc1", "", "catA"}, {"desc1", "configB2", "catB"}, {"desc2", "configD1", ""}, {"desc2", "configD2", ""}, {"desc2", "", ""}}) {
            PrintWriter printWriter = this.writerProvider.getPrintWriter(config[1], config[0], config[2]);
            printWriter.print("something");
            printWriter.flush();
            printWriter.close();
        }
        Set res = this.writerProvider.findAvailableConfigurationsForCategory("desc1", "catA");
        Assert.assertEquals((long)2L, (long)res.size());
        Assert.assertTrue((boolean)res.contains("configA1"));
        Assert.assertTrue((boolean)res.contains(""));
        res = this.writerProvider.findAvailableConfigurationsForCategory("desc1", "catB");
        Assert.assertEquals((long)1L, (long)res.size());
        Assert.assertTrue((boolean)res.contains("configB2"));
        res = this.writerProvider.findAvailableConfigurationsForCategory("desc2", "");
        Assert.assertEquals((long)3L, (long)res.size());
        Assert.assertTrue((boolean)res.contains("configD1"));
        Assert.assertTrue((boolean)res.contains("configD2"));
        Assert.assertTrue((boolean)res.contains(""));
    }

    static {
        cats = new String[]{"", "catA", "catB"};
    }
}

