package org.lsst.ccs.config;


import org.hibernate.annotations.Immutable;

import javax.persistence.*;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/**
 * A config profile in history.
 * @author bamade
 */
// Date: 12/04/12

    @Entity
    @Immutable
//@Table (name="ProfileHistory")
class PastConfigProfile extends ConfigProfile {
    private static final long serialVersionUID = 1424069242594632758L;
    //TODO : make  config classes non public and check on Config
    @Id
    private long id ;

    @ManyToOne (fetch=FetchType.EAGER)
    private GhostSubsystemDescription subsystemDesc ;

    //TODO: A map<Path,XXX> instead
    // IMMUTABLE
    @OneToMany (cascade = CascadeType.ALL, fetch=FetchType.EAGER)
    private /*@NotNull*/ Set<PastParameterConfiguration> parameterConfigurations ;

    //////////////////////////////// CONSTRUCTORS

     PastConfigProfile() {
    }

    /**
     * creates an historic entry from a config Profile to be deprecated and the "ghost" of a subsystem.
     *
     * @param ghost
     * @param oldProfile
     * @throws IllegalArgumentException if oldProfile is not registered in database or if subsystem description and its ghost are incompatibles
     */
    public PastConfigProfile(GhostSubsystemDescription ghost, AConfigProfile oldProfile) {
       super(oldProfile.getSubsystemName(),  oldProfile.getTag(),oldProfile.getCategoryName(), oldProfile.getConfigName());
        if(oldProfile.getId() == 0L) {
            throw new IllegalArgumentException("trying to create history date from non registered data") ;
        }
        // post check
       if(ghost.getId() != oldProfile.getSubsystemId()) {
           throw new IllegalArgumentException("ghost and profile have no common ID");
       }
        this.subsystemDesc = ghost ;
        this.id = oldProfile.getId() ;
        this.setStartTimestamp(oldProfile.getStartTimestamp());
        Set<PastParameterConfiguration> set = new HashSet<PastParameterConfiguration>();
        //// population of PastParameterConfiguration
        for(AParameterConfiguration conf : oldProfile.getParameterConfigurations()){
            ParameterDescription description = ghost.fetch(conf) ;
            GhostParameterDescription ghostDesc = (GhostParameterDescription) description ;
            PastParameterConfiguration pastConf = new PastParameterConfiguration(ghostDesc, conf);
            set.add(pastConf) ;
        }
        parameterConfigurations = Collections.unmodifiableSet(set) ;
        this.setPreviousConfigID(oldProfile.getPreviousConfigID());
        long endDate = System.currentTimeMillis() ;
        this.setEndTimestamp(endDate);
        oldProfile.setEndTimestamp(endDate);
    }

    //////////////////////////////// ACCESSORS/MUTATORS

    @Override
    public long getId() {
        return id;  //To change body of implemented methods use File | Settings | File Templates.
    }

    @Override
    protected void setId(long id) {
        this.id = id ;
    }


    @Override
    public SubsystemDescription getSubsystemDescription() {
        return this.subsystemDesc ;
    }

    @Override
    public Set<? extends ParameterConfiguration> getModifiedParameters() {
        //HIBERNATE PROBLEM
        return Collections.unmodifiableSet(parameterConfigurations);
    }
    
    @Override
    public ParameterConfiguration temporaryChangeConfigurationValue(String  parameterPath, long time, String value) {
        throw new ImmutableStateException("no modification of deprecated data") ;
    }

    @Override
    public void addParameterConfiguration(String parameterName, String value){
        throw new ImmutableStateException("no modification of deprecated data") ;
    }

    @Override
    public void addParameterConfigurations(ParameterConfiguration... parameterConfigurations) {
        throw new ImmutableStateException("no modification of deprecated data") ;
    }

    @Override
    public void removeParameterConfigurations(ParameterConfiguration... parameterConfigurations) {
        throw new ImmutableStateException("no modification of deprecated data") ;
    }

    public GhostSubsystemDescription getSubsystemDesc() {
        return subsystemDesc;
    }

    void setSubsystemDesc(GhostSubsystemDescription subsystemDesc) {
        this.subsystemDesc = subsystemDesc;
    }

    public Set<PastParameterConfiguration> getParameterConfigurations() {
        // HIBERNATE PROBLEM
        return Collections.unmodifiableSet(parameterConfigurations);
    }

     void setParameterConfigurations(Set<PastParameterConfiguration> parameterConfigurations) {
        this.parameterConfigurations = Collections.unmodifiableSet(parameterConfigurations);
    }
     
     public boolean isDirty(){
         return false;
     }
    ///////////////////////// UTILITIES
    //TODO: resurrect methods

}
