package org.lsst.ccs.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.Set;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.utilities.logging.Logger;

/**
 * Reads and Writes properties files from/to a FileSystem.
 *
 * @author LSST CCS Team
 */
public class FileWriterProvider implements WriterProvider {

    Logger logger = Logger.getLogger("org.lsst.ccs.config");

    @Override
    public PrintWriter getPrintWriter(String configName, String tagName, String categoryName) throws IOException {
        String baseName = new ConfigurationFileName(tagName, configName, categoryName).getFullName();
        //Check if the properties file already exists in the Bootstrap Environment
        String pathInBootstrap = BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories(baseName);
        //If it does not exist...
        if (pathInBootstrap == null) {
            // then check if a there is a Bootstrap user defined directory in which to write it.
            String topMostUserDirectory = BootstrapResourceUtils.getTopUserResourceDirectory();
            //If there is not Bootstrap user Directory defined.....
            if (topMostUserDirectory == null) {
                throw new RuntimeException("There is no external resource directory in which to write the configuration file. Please make sure to"
                        + " define one using environment variable CCS_RESOURCE_PATH.");
            } else {
                baseName = topMostUserDirectory + baseName;
            }
        } else {
            baseName = pathInBootstrap;
        }

        logger.info("Saving configuration  to " + baseName);
 
        return new PrintWriter(baseName, "ISO-8859-1");
    }

    @Override
    public Properties getConfigurationProperties(String configName, String tagName, String categoryName) throws IOException {
        String configFileName = new ConfigurationFileName(tagName, configName, categoryName).getFullName();
        Properties configProps = new Properties();
        InputStream propsIs = null;
        propsIs = BootstrapResourceUtils.getBootstrapResource(configFileName);
        if (propsIs == null) { // The resource could not be found
            return null;
        }
        configProps.load(propsIs);
        return configProps;
    }

    @Override
    public Set<String> findMatchingConfigurations(String pattern) {
        return BootstrapResourceUtils.findMatchingResources(pattern);
    }
}
