/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Properties;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.config.LocalConfigurationProxy;
import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class FileWriterProvider
implements LocalConfigurationProxy.WriterProvider {
    Logger logger = Logger.getLogger((String)"org.lsst.ccs.config");

    @Override
    public PrintWriter getPrintWriter(String configName, String tagName, String categoryName) throws IOException {
        String baseName = ConfigUtils.baseNameFromNames(configName, tagName, categoryName);
        String pathInBootstrap = BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories((String)baseName);
        if (pathInBootstrap == null) {
            String topMostUserDirectory = BootstrapResourceUtils.getTopUserResourceDirectory();
            if (topMostUserDirectory == null) {
                throw new RuntimeException("There is no external resource directory in which to write the configuration file. Please make sure to define one using environment variable CCS_RESOURCE_PATH.");
            }
            baseName = topMostUserDirectory + baseName;
        } else {
            baseName = pathInBootstrap;
        }
        if (!baseName.endsWith(".properties")) {
            baseName = baseName + ".properties";
        }
        this.logger.info((Object)("Saving configuration  to " + baseName));
        return new PrintWriter(baseName, "ISO-8859-1");
    }

    @Override
    public Properties getConfigurationProperties(String configName, String tagName, String categoryName) throws IOException {
        String configFileName = ConfigUtils.baseNameFromNames(configName, tagName, categoryName);
        if (!configFileName.endsWith(".properties")) {
            configFileName = configFileName + ".properties";
        }
        Properties configProps = new Properties();
        InputStream propsIs = null;
        propsIs = BootstrapResourceUtils.getBootstrapResource((String)configFileName);
        if (propsIs == null) {
            return null;
        }
        configProps.load(propsIs);
        return configProps;
    }
}

