package org.lsst.ccs.config;

/**
 * Two objects with the same ParameterPath are unique in their category.
 * The method would be used to fetch an object in a <TT>Set</TT>
 * using another <TT>PathObject</TT>
 * <P/>
 * Important note: these comparisons are not related to any order in parameters (for instance
 * order in the tree of components).
 */
public interface PathObject extends Comparable<PathObject> {
    
    @Override
    public default int compareTo(PathObject other) {

        String componentName = getPath().getComponentName();
        String otherComponentName = other.getPath().getComponentName();
        
        if(componentName.equals("main") && ! otherComponentName.equals("main")) {
            return 1 ;
        }
        if(otherComponentName.equals("main") && ! otherComponentName.equals("main/")) {
            return -1 ;
        }
        if (componentName.equals(otherComponentName)) {
            return getPath().getParameterName().compareTo(other.getPath().getParameterName());
        } else {
            return componentName.compareTo(otherComponentName);
        }
    }
    
    public ParameterPath getPath() ;
   
}
