package org.lsst.ccs.config;

import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.List;

/**
 * abstract class for all parameter configurations
 * @author bamade
 */
// Date: 11/04/12

    @MappedSuperclass
public abstract class ParameterConfiguration  implements Serializable, PathObject{

    /**
     * This is the configured value corresponding to the current configuration
     * for this parameter
     */
    protected String configuredValue ;

    /**
     * this transient field is to carry information about a failure in configuration "repair".
     * The corresponding parameter cannot be matched to a new <TT>SubsystemDescription</TT>
     * to which we try to attach this (possibly deprecated) Configuration.
     */
    @Transient
    protected Exception reConfigurationFailure ;


    ///////////////////////// CONSTRUCTORS

    protected ParameterConfiguration() {

    }
    protected ParameterConfiguration(String value) {
        this.configuredValue = value;
    }


    /////////////////////////// ACCESSORS/MUTATORS

    public abstract long getId() ;
    protected abstract void setId(long id) ;

    public boolean isReadOnly() {
        return getId() != 0L ;
    }

    public Exception getReConfigurationFailure() {
        return reConfigurationFailure;
    }

    public void setReConfigurationFailure(Exception reConfigurationFail) {
        this.reConfigurationFailure = reConfigurationFail;
    }

    public abstract ParameterDescription getDescription() ;

    public abstract List<? extends ValueEvent> getValueEvents() ;

    // public abstract void addValueEvent(ValueEvent event) ;

    /**
     * @return the configured value for this parameter
     */
    public String getConfiguredValue() {
        return configuredValue;
    }

    public String getValueAt(long date){
    if (hasChanged()) {
            List<? extends ValueEvent> eventList = getValueEvents();
            if (eventList == null) {
                return configuredValue;
            }
            //TODO: what to do with this values?
            String lastValue = configuredValue;
            for (ValueEvent event : eventList) {
                if (event.getTime() >= date) {
                    return lastValue;
                }
                lastValue = event.getValue();
            }
            return lastValue;
        } else {
            return configuredValue;
        }    
    }
    
    void setValue(String value) {
        /* if( isReadOnly()) {
            throw new ImmutableStateException("read only value") ;
        } */
        this.configuredValue = value;
    }

    /**
     * Modifies the configuredValue field
     * @param value
     * @throws ImmutableStateException if modification is for a registered object
     * @throws IllegalArgumentException if value is not coherent with type and constraints
     */
    public void modifyValue(String value){
        if( isReadOnly()){
            throw new ImmutableStateException("read only value");
        }
        setValue(value);
    }
    ///////////////////////////// IDENT METHODS
    // TODO: add id?

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof PathObject)) return false;

        PathObject that = (PathObject) o;
        ParameterDescription description = getDescription();
        if (!description.getPath().equals(that.getPath())) return false;

        return true;
    }

    @Override
    public String toString() {
        return  this.getId() + "{" + getId() +
                ": description=" + getDescription() +
                ", value='" + configuredValue + '\'' +
                '}';
    }

    @Override
    public int hashCode() {
        return getDescription().hashCode();
    }

    @Override
    public ParameterPath getPath() {
        return getDescription().getPath();
    }
    
    public boolean hasChanged(){
        return !(getValueEvents()==null || getValueEvents().isEmpty());
    }
}
